/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.jobs;

import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import de.uka.ipd.sdq.workflow.WorkflowFailedException;
import de.uka.ipd.sdq.workflow.jobs.AbstractCompositeJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;

public class SequentialJob
extends AbstractCompositeJob {
    private boolean cleanUpImmediately = true;

    public SequentialJob() {
        this("Sequential Job");
    }

    public SequentialJob(String name) {
        this.setName(name);
    }

    public SequentialJob(boolean cleanUpImmediately) {
        this();
        this.cleanUpImmediately = cleanUpImmediately;
    }

    public SequentialJob(String name, boolean cleanUpImmediately) {
        this(cleanUpImmediately);
        this.setName(name);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.cleanUpImmediately) {
            this.executeWithImmediateCleanUp(monitor);
        } else {
            this.executeWithDelayedCleanUp(monitor);
        }
    }

    private void executeWithDelayedCleanUp(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(monitor, 1);
        subProgressMonitor.beginTask(String.valueOf(this.getName()) + " Execution", this.myJobs.size());
        for (IJob job : this.myJobs) {
            if (monitor.isCanceled()) {
                throw new UserCanceledException();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Palladio Workflow-Engine: Running job " + job.getName()));
            }
            subProgressMonitor.subTask(job.getName());
            this.myExecutedJobs.push(job);
            job.execute((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.worked(1);
        }
        subProgressMonitor.done();
    }

    private void executeWithImmediateCleanUp(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(monitor, 1);
        subProgressMonitor.beginTask(String.valueOf(this.getName()) + " Execution", this.myJobs.size());
        int totalNumberOfJobs = this.myJobs.size();
        int i = 0;
        while (i < totalNumberOfJobs) {
            Exception workflowException;
            IJob job;
            block8: {
                if (monitor.isCanceled()) {
                    throw new UserCanceledException();
                }
                job = (IJob)this.myJobs.getFirst();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Palladio Workflow-Engine: Running job " + job.getName()));
                }
                subProgressMonitor.subTask(job.getName());
                workflowException = null;
                try {
                    job.execute((IProgressMonitor)subProgressMonitor);
                }
                catch (Exception e) {
                    workflowException = e;
                }
                subProgressMonitor.worked(1);
                subProgressMonitor.subTask("Cleaning up job " + job.getName());
                try {
                    job.cleanup((IProgressMonitor)subProgressMonitor);
                }
                catch (CleanupFailedException e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block8;
                    this.logger.warn((Object)("Failed to cleanup job " + job.getName()));
                }
            }
            subProgressMonitor.worked(1);
            if (workflowException != null) {
                throw new WorkflowFailedException("A workflow job failed", workflowException);
            }
            this.myJobs.removeFirst();
            job = null;
            ++i;
        }
        subProgressMonitor.done();
    }

    @Override
    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        if (!this.cleanUpImmediately) {
            super.cleanup(monitor);
        }
    }
}

