/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.CoreImages;
import de.upb.swt.core.ui.properties.PropertiesColors;
import de.upb.swt.core.ui.properties.util.PropertiesAdaptor;
import de.upb.swt.core.ui.properties.util.State;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractPropertySection
implements ISection {
    protected static final String EMPTY = "";
    protected static final int WIDTH_LABEL = 120;
    protected static final int SIZE_MARGIN = 6;
    private EObject element;
    private EditingDomain editingDomain;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (AbstractPropertySection.this.shouldRefresh(msg)) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractPropertySection.this.refresh();
                        }
                    });
                } else {
                    AbstractPropertySection.this.refresh();
                }
            }
        }
    };
    private TabbedPropertySheetPage page;
    private ISelection selection;

    public final void createControls(Composite parent, TabbedPropertySheetPage page) {
        this.page = page;
        FormLayout layout = new FormLayout();
        layout.marginTop = 6;
        layout.marginRight = 6;
        layout.marginLeft = 6;
        Composite section = page.getWidgetFactory().createFlatFormComposite(parent);
        section.setLayout((Layout)layout);
        this.createWidgets(section, page.getWidgetFactory());
        this.layoutWidgets();
        this.hookWidgetListeners();
    }

    protected abstract void createWidgets(Composite var1, TabbedPropertySheetWidgetFactory var2);

    protected void layoutWidgets() {
    }

    protected void hookWidgetListeners() {
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.equals(this.selection)) {
            return;
        }
        this.removeAdapters();
        this.selection = selection;
        this.element = PropertiesAdaptor.adapt(selection);
        this.editingDomain = PropertiesAdaptor.getEditingDomain(this.element);
        Assert.isNotNull((Object)this.element);
        Assert.isNotNull((Object)this.editingDomain);
        this.addAdapters();
    }

    public void aboutToBeHidden() {
        this.removeAdapters();
    }

    protected void removeAdapters() {
        if (this.element != null) {
            this.element.eAdapters().remove((Object)this.listener);
        }
    }

    protected void addAdapters() {
        if (this.element != null) {
            this.element.eAdapters().add((Object)this.listener);
        }
    }

    public void aboutToBeShown() {
    }

    public void dispose() {
    }

    public int getMinimumHeight() {
        return -1;
    }

    public void refresh() {
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    protected final void add(EStructuralFeature feature, Collection<Object> values) {
        this.execute(AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, values));
    }

    protected final void add(EStructuralFeature feature, Object value) {
        this.execute(AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
    }

    protected final void remove(EStructuralFeature feature, Collection<Object> values) {
        this.execute(RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, values));
    }

    protected final void remove(EStructuralFeature feature, Object value) {
        this.execute(RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
    }

    protected final void set(EStructuralFeature feature, Object value) {
        this.execute(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getElement(), (Object)feature, (Object)value));
    }

    protected final void execute(Command command) {
        this.getEditingDomain().getCommandStack().execute(command);
        this.postExecute();
    }

    protected final EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void postExecute() {
    }

    protected final Object getValue(EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        return this.getElement().eGet(feature);
    }

    protected boolean shouldRefresh(Notification msg) {
        return msg.getEventType() != 8 && this.getElement() != null;
    }

    protected EObject getElement() {
        return this.element;
    }

    protected final void decorateBackground(Control control, State state) {
        Assert.isNotNull((Object)control);
        Color color = null;
        if (state != null) {
            switch (state.getType()) {
                case ERROR: {
                    color = PropertiesColors.get(PropertiesColors.ERROR);
                    break;
                }
                case WARNING: {
                    color = PropertiesColors.get(PropertiesColors.WARNING);
                    break;
                }
            }
        }
        if (!control.isDisposed()) {
            control.setBackground(color);
        }
    }

    protected final void decorateImage(Label label, State state) {
        Assert.isNotNull((Object)label);
        Image image = null;
        String text = null;
        if (state != null) {
            text = state.getMessage();
            switch (state.getType()) {
                case ERROR: {
                    image = CoreImages.get((String)"icons/state/error.png");
                    break;
                }
                case WARNING: {
                    image = CoreImages.get((String)"icons/state/warning.png");
                    break;
                }
                case INFO: {
                    image = CoreImages.get((String)"icons/state/information.png");
                }
            }
        }
        if (!label.isDisposed()) {
            label.setImage(image);
            label.setToolTipText(text);
        }
    }

    protected final TabbedPropertySheetPage getPage() {
        return this.page;
    }

    protected final void refreshTitle() {
        if (this.page != null) {
            this.page.labelProviderChanged(new LabelProviderChangedEvent(null));
        }
    }
}

