/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractFeaturePropertySection;
import de.upb.swt.core.ui.properties.util.State;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractTextSection
extends AbstractFeaturePropertySection {
    private Label label;
    private Text text;
    private Label icon;

    @Override
    public void refresh() {
        if (this.isReady()) {
            EDataType type = this.getType();
            Object value = this.getValue();
            String stringValue = EcoreUtil.convertToString((EDataType)type, (Object)value);
            if (!AbstractTextSection.isEqual(this.text.getText(), stringValue)) {
                if (stringValue == null) {
                    stringValue = "";
                }
                this.text.setText(stringValue);
            }
            this.validate();
        }
    }

    private boolean isReady() {
        return this.text != null && !this.text.isDisposed();
    }

    private void doExecute() {
        Object oldValue = this.getValue();
        Object newValue = EcoreUtil.createFromString((EDataType)this.getType(), (String)this.text.getText());
        boolean abort = false;
        if (oldValue != null) {
            abort = oldValue.equals(newValue);
        }
        if (!abort && newValue != null) {
            abort = newValue.equals(oldValue);
        }
        if (!abort) {
            Point selection = this.text.getSelection();
            this.set(newValue);
            this.text.setSelection(selection);
        }
    }

    private EDataType getType() {
        return (EDataType)this.getFeature().getEType();
    }

    private static boolean isEqual(String one, String two) {
        if (one == null) {
            one = "";
        }
        if (two == null) {
            two = "";
        }
        return one.equals(two);
    }

    private void validate() {
        String value = this.getValue(this.text.getText());
        State state = this.validate(value);
        this.decorateBackground((Control)this.text, state);
        this.decorateImage(this.icon, state);
    }

    protected String getValue(String value) {
        return value;
    }

    protected State validate(String value) {
        return State.NONE;
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return this.isMultiLine();
    }

    @Override
    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        String labelText = String.valueOf(this.getLabelText()) + ':';
        this.label = factory.createLabel(parent, labelText, 131072);
        this.text = factory.createText(parent, "", 0x800 | (this.isMultiLine() ? 2 : 4));
        this.icon = factory.createLabel(parent, "");
    }

    protected boolean isMultiLine() {
        return false;
    }

    protected abstract String getLabelText();

    @Override
    protected void hookWidgetListeners() {
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractTextSection.this.text.setFocus();
                AbstractTextSection.this.text.selectAll();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractTextSection.this.doExecute();
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ('\r' == e.character) {
                    AbstractTextSection.this.doExecute();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractTextSection.this.validate();
            }
        });
    }

    @Override
    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 120);
        data.right = new FormAttachment(100, -34);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.text.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.text, 12, 131072);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.bottom = new FormAttachment((Control)this.text, 0, 1024);
        this.icon.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.text, -6);
        data.top = new FormAttachment((Control)this.text, 2, 128);
        data.bottom = new FormAttachment((Control)this.text, 0, 1024);
        this.label.setLayoutData((Object)data);
    }
}

