/*
 * Decompiled with CFR 0.152.
 */
package de.upb.swt.core.ui.runtime;

import de.upb.swt.core.runtime.AbstractCoreActivator;
import de.upb.swt.core.ui.runtime.IActivator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractActivator
extends AbstractCoreActivator
implements IActivator {
    private static final String DIALOG_SETTINGS = "dialog_settings.xml";
    private static final String ENCODING = "UTF-8";
    private static final String WORKBENCH = "Workbench";
    private ColorRegistry colorRegistry;
    private IDialogSettings dialogSettings;
    private ImageRegistry imageRegistry;
    private ScopedPreferenceStore preferenceStore;

    public final void stop(BundleContext context) throws Exception {
        this.dispose();
        this.colorRegistry = null;
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
        this.imageRegistry = null;
        if (this.dialogSettings != null) {
            try {
                IPath path = Platform.getStateLocation((Bundle)this.getBundle());
                if (path == null) {
                    throw new NullPointerException("The system is running with no data area.");
                }
                this.dialogSettings.save(path.append(DIALOG_SETTINGS).toOSString());
            }
            catch (IOException e) {
                this.error("Could not save dialog settings!", e);
            }
            catch (IllegalStateException e) {
                this.error("Could not save dialog settings!", e);
            }
            catch (NullPointerException e) {
                this.error("Could not save dialog settings!", e);
            }
        }
        this.dialogSettings = null;
        if (this.preferenceStore != null) {
            try {
                this.getPreferenceStore().save();
            }
            catch (IOException e) {
                this.error("Could not save preference store!", e);
            }
        }
        this.preferenceStore = null;
        super.stop(context);
    }

    protected abstract void dispose();

    public ScopedPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getID());
        }
        return this.preferenceStore;
    }

    @Override
    public Color getColor(String key) {
        if (this.getColorRegistry().hasValueFor(key)) {
            return this.getColorRegistry().get(key);
        }
        return null;
    }

    protected final void addColor(String key, RGB rgb) {
        if (this.getColorRegistry().hasValueFor(key)) {
            this.warn(String.format("A color with the key '%1s' has already been added to the registry.", key));
            return;
        }
        this.getColorRegistry().put(key, rgb);
    }

    private ColorRegistry getColorRegistry() {
        if (this.colorRegistry == null) {
            this.colorRegistry = new ColorRegistry(this.getDisplay());
        }
        return this.colorRegistry;
    }

    @Override
    public final Image getImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image != null) {
            return image;
        }
        return this.getImageRegistry().get(null);
    }

    @Override
    public final ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(path);
        if (descriptor != null) {
            return descriptor;
        }
        return this.getImageRegistry().getDescriptor(null);
    }

    protected final void addImage(String path) {
        this.addImage(path, path);
    }

    protected final void addImage(String key, String path) {
        ImageDescriptor descriptor = this.getImageRegistry().getDescriptor(key);
        if (descriptor != null) {
            this.warn(String.format("An image with the key '%1s' has already been added to the registry.", key));
            return;
        }
        descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.getID(), (String)path);
        if (descriptor == null) {
            this.warn(String.format("The image under the path '%1s' could not be found.", path));
            return;
        }
        this.getImageRegistry().put(key, descriptor);
    }

    protected ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry(this.getDisplay());
            this.imageRegistry.put(null, ImageDescriptor.getMissingImageDescriptor());
        }
        return this.imageRegistry;
    }

    @Override
    public Display getDisplay() {
        if (Display.getCurrent() != null) {
            return Display.getCurrent();
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        throw new SWTError(22);
    }

    @Override
    public final IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = this.createDialogSettings();
        }
        return this.dialogSettings;
    }

    private IDialogSettings createDialogSettings() {
        String readWritePath;
        File settingsFile;
        DialogSettings dialogSettings = new DialogSettings(WORKBENCH);
        IPath path = Platform.getStateLocation((Bundle)this.getBundle());
        if (path != null && (settingsFile = new File(readWritePath = path.append(DIALOG_SETTINGS).toOSString())).exists()) {
            try {
                dialogSettings.load(readWritePath);
            }
            catch (IOException e) {
                dialogSettings = new DialogSettings(WORKBENCH);
            }
            return dialogSettings;
        }
        URL dsURL = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(DIALOG_SETTINGS), null);
        if (dsURL == null) {
            return dialogSettings;
        }
        InputStream is = null;
        try {
            try {
                is = dsURL.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, ENCODING));
                dialogSettings.load((Reader)reader);
            }
            catch (IOException e) {
                dialogSettings = new DialogSettings(WORKBENCH);
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return dialogSettings;
    }

    public final void start(BundleContext context) throws Exception {
        super.start(context);
        this.initialize();
    }

    protected abstract void initialize();
}

