/**
 * *******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sebastien Minguet (Mia-Software) - initial API and implementation
 *     Frederic Madiot (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 *     Erwan Breton (Sodifrance) - initial API and implementation
 *     Romain Dervaux (Mia-Software) - initial API and implementation
 * *******************************************************************************
 */
package org.eclipse.gmt.modisco.java.emf.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.gmt.modisco.java.emf.util.JavaAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class JavaItemProviderAdapterFactory extends JavaAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JavaItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Annotation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationItemProvider annotationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Annotation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationAdapter() {
		if (annotationItemProvider == null) {
			annotationItemProvider = new AnnotationItemProvider(this);
		}

		return annotationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Archive} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArchiveItemProvider archiveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Archive}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArchiveAdapter() {
		if (archiveItemProvider == null) {
			archiveItemProvider = new ArchiveItemProvider(this);
		}

		return archiveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.AssertStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssertStatementItemProvider assertStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.AssertStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssertStatementAdapter() {
		if (assertStatementItemProvider == null) {
			assertStatementItemProvider = new AssertStatementItemProvider(this);
		}

		return assertStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.AnnotationMemberValuePair} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationMemberValuePairItemProvider annotationMemberValuePairItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.AnnotationMemberValuePair}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationMemberValuePairAdapter() {
		if (annotationMemberValuePairItemProvider == null) {
			annotationMemberValuePairItemProvider = new AnnotationMemberValuePairItemProvider(this);
		}

		return annotationMemberValuePairItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.AnnotationTypeDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationTypeDeclarationItemProvider annotationTypeDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.AnnotationTypeDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationTypeDeclarationAdapter() {
		if (annotationTypeDeclarationItemProvider == null) {
			annotationTypeDeclarationItemProvider = new AnnotationTypeDeclarationItemProvider(this);
		}

		return annotationTypeDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.AnnotationTypeMemberDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnnotationTypeMemberDeclarationItemProvider annotationTypeMemberDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.AnnotationTypeMemberDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnnotationTypeMemberDeclarationAdapter() {
		if (annotationTypeMemberDeclarationItemProvider == null) {
			annotationTypeMemberDeclarationItemProvider = new AnnotationTypeMemberDeclarationItemProvider(this);
		}

		return annotationTypeMemberDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.AnonymousClassDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnonymousClassDeclarationItemProvider anonymousClassDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.AnonymousClassDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnonymousClassDeclarationAdapter() {
		if (anonymousClassDeclarationItemProvider == null) {
			anonymousClassDeclarationItemProvider = new AnonymousClassDeclarationItemProvider(this);
		}

		return anonymousClassDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ArrayAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayAccessItemProvider arrayAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ArrayAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayAccessAdapter() {
		if (arrayAccessItemProvider == null) {
			arrayAccessItemProvider = new ArrayAccessItemProvider(this);
		}

		return arrayAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ArrayCreation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayCreationItemProvider arrayCreationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ArrayCreation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayCreationAdapter() {
		if (arrayCreationItemProvider == null) {
			arrayCreationItemProvider = new ArrayCreationItemProvider(this);
		}

		return arrayCreationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ArrayInitializer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayInitializerItemProvider arrayInitializerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ArrayInitializer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayInitializerAdapter() {
		if (arrayInitializerItemProvider == null) {
			arrayInitializerItemProvider = new ArrayInitializerItemProvider(this);
		}

		return arrayInitializerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ArrayLengthAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayLengthAccessItemProvider arrayLengthAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ArrayLengthAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayLengthAccessAdapter() {
		if (arrayLengthAccessItemProvider == null) {
			arrayLengthAccessItemProvider = new ArrayLengthAccessItemProvider(this);
		}

		return arrayLengthAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ArrayType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ArrayTypeItemProvider arrayTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ArrayType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createArrayTypeAdapter() {
		if (arrayTypeItemProvider == null) {
			arrayTypeItemProvider = new ArrayTypeItemProvider(this);
		}

		return arrayTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Assignment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AssignmentItemProvider assignmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Assignment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAssignmentAdapter() {
		if (assignmentItemProvider == null) {
			assignmentItemProvider = new AssignmentItemProvider(this);
		}

		return assignmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.BooleanLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanLiteralItemProvider booleanLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.BooleanLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanLiteralAdapter() {
		if (booleanLiteralItemProvider == null) {
			booleanLiteralItemProvider = new BooleanLiteralItemProvider(this);
		}

		return booleanLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.BlockComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockCommentItemProvider blockCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.BlockComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockCommentAdapter() {
		if (blockCommentItemProvider == null) {
			blockCommentItemProvider = new BlockCommentItemProvider(this);
		}

		return blockCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Block} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BlockItemProvider blockItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Block}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlockAdapter() {
		if (blockItemProvider == null) {
			blockItemProvider = new BlockItemProvider(this);
		}

		return blockItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.BreakStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BreakStatementItemProvider breakStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.BreakStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBreakStatementAdapter() {
		if (breakStatementItemProvider == null) {
			breakStatementItemProvider = new BreakStatementItemProvider(this);
		}

		return breakStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.CastExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CastExpressionItemProvider castExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.CastExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCastExpressionAdapter() {
		if (castExpressionItemProvider == null) {
			castExpressionItemProvider = new CastExpressionItemProvider(this);
		}

		return castExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.CatchClause} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CatchClauseItemProvider catchClauseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.CatchClause}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCatchClauseAdapter() {
		if (catchClauseItemProvider == null) {
			catchClauseItemProvider = new CatchClauseItemProvider(this);
		}

		return catchClauseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.CharacterLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CharacterLiteralItemProvider characterLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.CharacterLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCharacterLiteralAdapter() {
		if (characterLiteralItemProvider == null) {
			characterLiteralItemProvider = new CharacterLiteralItemProvider(this);
		}

		return characterLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ClassFile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassFileItemProvider classFileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ClassFile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassFileAdapter() {
		if (classFileItemProvider == null) {
			classFileItemProvider = new ClassFileItemProvider(this);
		}

		return classFileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ClassInstanceCreation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassInstanceCreationItemProvider classInstanceCreationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ClassInstanceCreation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassInstanceCreationAdapter() {
		if (classInstanceCreationItemProvider == null) {
			classInstanceCreationItemProvider = new ClassInstanceCreationItemProvider(this);
		}

		return classInstanceCreationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ConstructorDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstructorDeclarationItemProvider constructorDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ConstructorDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstructorDeclarationAdapter() {
		if (constructorDeclarationItemProvider == null) {
			constructorDeclarationItemProvider = new ConstructorDeclarationItemProvider(this);
		}

		return constructorDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ConditionalExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConditionalExpressionItemProvider conditionalExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ConditionalExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConditionalExpressionAdapter() {
		if (conditionalExpressionItemProvider == null) {
			conditionalExpressionItemProvider = new ConditionalExpressionItemProvider(this);
		}

		return conditionalExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ConstructorInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConstructorInvocationItemProvider constructorInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ConstructorInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConstructorInvocationAdapter() {
		if (constructorInvocationItemProvider == null) {
			constructorInvocationItemProvider = new ConstructorInvocationItemProvider(this);
		}

		return constructorInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ClassDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassDeclarationItemProvider classDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ClassDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassDeclarationAdapter() {
		if (classDeclarationItemProvider == null) {
			classDeclarationItemProvider = new ClassDeclarationItemProvider(this);
		}

		return classDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.CompilationUnit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompilationUnitItemProvider compilationUnitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.CompilationUnit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompilationUnitAdapter() {
		if (compilationUnitItemProvider == null) {
			compilationUnitItemProvider = new CompilationUnitItemProvider(this);
		}

		return compilationUnitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ContinueStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContinueStatementItemProvider continueStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ContinueStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContinueStatementAdapter() {
		if (continueStatementItemProvider == null) {
			continueStatementItemProvider = new ContinueStatementItemProvider(this);
		}

		return continueStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.DoStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoStatementItemProvider doStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.DoStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDoStatementAdapter() {
		if (doStatementItemProvider == null) {
			doStatementItemProvider = new DoStatementItemProvider(this);
		}

		return doStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.EmptyStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EmptyStatementItemProvider emptyStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.EmptyStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEmptyStatementAdapter() {
		if (emptyStatementItemProvider == null) {
			emptyStatementItemProvider = new EmptyStatementItemProvider(this);
		}

		return emptyStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.EnhancedForStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnhancedForStatementItemProvider enhancedForStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.EnhancedForStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnhancedForStatementAdapter() {
		if (enhancedForStatementItemProvider == null) {
			enhancedForStatementItemProvider = new EnhancedForStatementItemProvider(this);
		}

		return enhancedForStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.EnumConstantDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumConstantDeclarationItemProvider enumConstantDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.EnumConstantDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumConstantDeclarationAdapter() {
		if (enumConstantDeclarationItemProvider == null) {
			enumConstantDeclarationItemProvider = new EnumConstantDeclarationItemProvider(this);
		}

		return enumConstantDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.EnumDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumDeclarationItemProvider enumDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.EnumDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumDeclarationAdapter() {
		if (enumDeclarationItemProvider == null) {
			enumDeclarationItemProvider = new EnumDeclarationItemProvider(this);
		}

		return enumDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ExpressionStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExpressionStatementItemProvider expressionStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ExpressionStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExpressionStatementAdapter() {
		if (expressionStatementItemProvider == null) {
			expressionStatementItemProvider = new ExpressionStatementItemProvider(this);
		}

		return expressionStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.FieldAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldAccessItemProvider fieldAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.FieldAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFieldAccessAdapter() {
		if (fieldAccessItemProvider == null) {
			fieldAccessItemProvider = new FieldAccessItemProvider(this);
		}

		return fieldAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.FieldDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldDeclarationItemProvider fieldDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.FieldDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFieldDeclarationAdapter() {
		if (fieldDeclarationItemProvider == null) {
			fieldDeclarationItemProvider = new FieldDeclarationItemProvider(this);
		}

		return fieldDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ForStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ForStatementItemProvider forStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ForStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createForStatementAdapter() {
		if (forStatementItemProvider == null) {
			forStatementItemProvider = new ForStatementItemProvider(this);
		}

		return forStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.IfStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IfStatementItemProvider ifStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.IfStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIfStatementAdapter() {
		if (ifStatementItemProvider == null) {
			ifStatementItemProvider = new IfStatementItemProvider(this);
		}

		return ifStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ImportDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportDeclarationItemProvider importDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ImportDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImportDeclarationAdapter() {
		if (importDeclarationItemProvider == null) {
			importDeclarationItemProvider = new ImportDeclarationItemProvider(this);
		}

		return importDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.InfixExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InfixExpressionItemProvider infixExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.InfixExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInfixExpressionAdapter() {
		if (infixExpressionItemProvider == null) {
			infixExpressionItemProvider = new InfixExpressionItemProvider(this);
		}

		return infixExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Initializer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InitializerItemProvider initializerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Initializer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInitializerAdapter() {
		if (initializerItemProvider == null) {
			initializerItemProvider = new InitializerItemProvider(this);
		}

		return initializerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.InstanceofExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InstanceofExpressionItemProvider instanceofExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.InstanceofExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInstanceofExpressionAdapter() {
		if (instanceofExpressionItemProvider == null) {
			instanceofExpressionItemProvider = new InstanceofExpressionItemProvider(this);
		}

		return instanceofExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.InterfaceDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceDeclarationItemProvider interfaceDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.InterfaceDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceDeclarationAdapter() {
		if (interfaceDeclarationItemProvider == null) {
			interfaceDeclarationItemProvider = new InterfaceDeclarationItemProvider(this);
		}

		return interfaceDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Javadoc} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JavadocItemProvider javadocItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Javadoc}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJavadocAdapter() {
		if (javadocItemProvider == null) {
			javadocItemProvider = new JavadocItemProvider(this);
		}

		return javadocItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.LabeledStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabeledStatementItemProvider labeledStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.LabeledStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabeledStatementAdapter() {
		if (labeledStatementItemProvider == null) {
			labeledStatementItemProvider = new LabeledStatementItemProvider(this);
		}

		return labeledStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.LineComment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LineCommentItemProvider lineCommentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.LineComment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLineCommentAdapter() {
		if (lineCommentItemProvider == null) {
			lineCommentItemProvider = new LineCommentItemProvider(this);
		}

		return lineCommentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Manifest} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManifestItemProvider manifestItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Manifest}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManifestAdapter() {
		if (manifestItemProvider == null) {
			manifestItemProvider = new ManifestItemProvider(this);
		}

		return manifestItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ManifestAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManifestAttributeItemProvider manifestAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ManifestAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManifestAttributeAdapter() {
		if (manifestAttributeItemProvider == null) {
			manifestAttributeItemProvider = new ManifestAttributeItemProvider(this);
		}

		return manifestAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ManifestEntry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ManifestEntryItemProvider manifestEntryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ManifestEntry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createManifestEntryAdapter() {
		if (manifestEntryItemProvider == null) {
			manifestEntryItemProvider = new ManifestEntryItemProvider(this);
		}

		return manifestEntryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.MemberRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemberRefItemProvider memberRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.MemberRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemberRefAdapter() {
		if (memberRefItemProvider == null) {
			memberRefItemProvider = new MemberRefItemProvider(this);
		}

		return memberRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.MethodDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodDeclarationItemProvider methodDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.MethodDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodDeclarationAdapter() {
		if (methodDeclarationItemProvider == null) {
			methodDeclarationItemProvider = new MethodDeclarationItemProvider(this);
		}

		return methodDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.MethodInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodInvocationItemProvider methodInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.MethodInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodInvocationAdapter() {
		if (methodInvocationItemProvider == null) {
			methodInvocationItemProvider = new MethodInvocationItemProvider(this);
		}

		return methodInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.MethodRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodRefItemProvider methodRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.MethodRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodRefAdapter() {
		if (methodRefItemProvider == null) {
			methodRefItemProvider = new MethodRefItemProvider(this);
		}

		return methodRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.MethodRefParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MethodRefParameterItemProvider methodRefParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.MethodRefParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMethodRefParameterAdapter() {
		if (methodRefParameterItemProvider == null) {
			methodRefParameterItemProvider = new MethodRefParameterItemProvider(this);
		}

		return methodRefParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Model} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModelItemProvider modelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Model}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModelAdapter() {
		if (modelItemProvider == null) {
			modelItemProvider = new ModelItemProvider(this);
		}

		return modelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Modifier} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModifierItemProvider modifierItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Modifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModifierAdapter() {
		if (modifierItemProvider == null) {
			modifierItemProvider = new ModifierItemProvider(this);
		}

		return modifierItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.NumberLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NumberLiteralItemProvider numberLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.NumberLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNumberLiteralAdapter() {
		if (numberLiteralItemProvider == null) {
			numberLiteralItemProvider = new NumberLiteralItemProvider(this);
		}

		return numberLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.NullLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullLiteralItemProvider nullLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.NullLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullLiteralAdapter() {
		if (nullLiteralItemProvider == null) {
			nullLiteralItemProvider = new NullLiteralItemProvider(this);
		}

		return nullLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PackageAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageAccessItemProvider packageAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PackageAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAccessAdapter() {
		if (packageAccessItemProvider == null) {
			packageAccessItemProvider = new PackageAccessItemProvider(this);
		}

		return packageAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ParameterizedType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterizedTypeItemProvider parameterizedTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ParameterizedType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterizedTypeAdapter() {
		if (parameterizedTypeItemProvider == null) {
			parameterizedTypeItemProvider = new ParameterizedTypeItemProvider(this);
		}

		return parameterizedTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ParenthesizedExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParenthesizedExpressionItemProvider parenthesizedExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ParenthesizedExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParenthesizedExpressionAdapter() {
		if (parenthesizedExpressionItemProvider == null) {
			parenthesizedExpressionItemProvider = new ParenthesizedExpressionItemProvider(this);
		}

		return parenthesizedExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PostfixExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PostfixExpressionItemProvider postfixExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PostfixExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPostfixExpressionAdapter() {
		if (postfixExpressionItemProvider == null) {
			postfixExpressionItemProvider = new PostfixExpressionItemProvider(this);
		}

		return postfixExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrefixExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrefixExpressionItemProvider prefixExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrefixExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrefixExpressionAdapter() {
		if (prefixExpressionItemProvider == null) {
			prefixExpressionItemProvider = new PrefixExpressionItemProvider(this);
		}

		return prefixExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeItemProvider primitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeAdapter() {
		if (primitiveTypeItemProvider == null) {
			primitiveTypeItemProvider = new PrimitiveTypeItemProvider(this);
		}

		return primitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeBoolean} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeBooleanItemProvider primitiveTypeBooleanItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeBoolean}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeBooleanAdapter() {
		if (primitiveTypeBooleanItemProvider == null) {
			primitiveTypeBooleanItemProvider = new PrimitiveTypeBooleanItemProvider(this);
		}

		return primitiveTypeBooleanItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeByte} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeByteItemProvider primitiveTypeByteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeByte}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeByteAdapter() {
		if (primitiveTypeByteItemProvider == null) {
			primitiveTypeByteItemProvider = new PrimitiveTypeByteItemProvider(this);
		}

		return primitiveTypeByteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeChar} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeCharItemProvider primitiveTypeCharItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeChar}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeCharAdapter() {
		if (primitiveTypeCharItemProvider == null) {
			primitiveTypeCharItemProvider = new PrimitiveTypeCharItemProvider(this);
		}

		return primitiveTypeCharItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeDouble} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeDoubleItemProvider primitiveTypeDoubleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeDouble}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeDoubleAdapter() {
		if (primitiveTypeDoubleItemProvider == null) {
			primitiveTypeDoubleItemProvider = new PrimitiveTypeDoubleItemProvider(this);
		}

		return primitiveTypeDoubleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeShort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeShortItemProvider primitiveTypeShortItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeShort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeShortAdapter() {
		if (primitiveTypeShortItemProvider == null) {
			primitiveTypeShortItemProvider = new PrimitiveTypeShortItemProvider(this);
		}

		return primitiveTypeShortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeFloat} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeFloatItemProvider primitiveTypeFloatItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeFloat}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeFloatAdapter() {
		if (primitiveTypeFloatItemProvider == null) {
			primitiveTypeFloatItemProvider = new PrimitiveTypeFloatItemProvider(this);
		}

		return primitiveTypeFloatItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeInt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeIntItemProvider primitiveTypeIntItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeInt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeIntAdapter() {
		if (primitiveTypeIntItemProvider == null) {
			primitiveTypeIntItemProvider = new PrimitiveTypeIntItemProvider(this);
		}

		return primitiveTypeIntItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeLong} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeLongItemProvider primitiveTypeLongItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeLong}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeLongAdapter() {
		if (primitiveTypeLongItemProvider == null) {
			primitiveTypeLongItemProvider = new PrimitiveTypeLongItemProvider(this);
		}

		return primitiveTypeLongItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.PrimitiveTypeVoid} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeVoidItemProvider primitiveTypeVoidItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.PrimitiveTypeVoid}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeVoidAdapter() {
		if (primitiveTypeVoidItemProvider == null) {
			primitiveTypeVoidItemProvider = new PrimitiveTypeVoidItemProvider(this);
		}

		return primitiveTypeVoidItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ReturnStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReturnStatementItemProvider returnStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ReturnStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReturnStatementAdapter() {
		if (returnStatementItemProvider == null) {
			returnStatementItemProvider = new ReturnStatementItemProvider(this);
		}

		return returnStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SingleVariableAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleVariableAccessItemProvider singleVariableAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SingleVariableAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleVariableAccessAdapter() {
		if (singleVariableAccessItemProvider == null) {
			singleVariableAccessItemProvider = new SingleVariableAccessItemProvider(this);
		}

		return singleVariableAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SingleVariableDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleVariableDeclarationItemProvider singleVariableDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SingleVariableDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSingleVariableDeclarationAdapter() {
		if (singleVariableDeclarationItemProvider == null) {
			singleVariableDeclarationItemProvider = new SingleVariableDeclarationItemProvider(this);
		}

		return singleVariableDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.StringLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringLiteralItemProvider stringLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.StringLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringLiteralAdapter() {
		if (stringLiteralItemProvider == null) {
			stringLiteralItemProvider = new StringLiteralItemProvider(this);
		}

		return stringLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SuperConstructorInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuperConstructorInvocationItemProvider superConstructorInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SuperConstructorInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuperConstructorInvocationAdapter() {
		if (superConstructorInvocationItemProvider == null) {
			superConstructorInvocationItemProvider = new SuperConstructorInvocationItemProvider(this);
		}

		return superConstructorInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SuperFieldAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuperFieldAccessItemProvider superFieldAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SuperFieldAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuperFieldAccessAdapter() {
		if (superFieldAccessItemProvider == null) {
			superFieldAccessItemProvider = new SuperFieldAccessItemProvider(this);
		}

		return superFieldAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SuperMethodInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuperMethodInvocationItemProvider superMethodInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SuperMethodInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuperMethodInvocationAdapter() {
		if (superMethodInvocationItemProvider == null) {
			superMethodInvocationItemProvider = new SuperMethodInvocationItemProvider(this);
		}

		return superMethodInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SwitchCase} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwitchCaseItemProvider switchCaseItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SwitchCase}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwitchCaseAdapter() {
		if (switchCaseItemProvider == null) {
			switchCaseItemProvider = new SwitchCaseItemProvider(this);
		}

		return switchCaseItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SwitchStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SwitchStatementItemProvider switchStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SwitchStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSwitchStatementAdapter() {
		if (switchStatementItemProvider == null) {
			switchStatementItemProvider = new SwitchStatementItemProvider(this);
		}

		return switchStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.SynchronizedStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SynchronizedStatementItemProvider synchronizedStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.SynchronizedStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSynchronizedStatementAdapter() {
		if (synchronizedStatementItemProvider == null) {
			synchronizedStatementItemProvider = new SynchronizedStatementItemProvider(this);
		}

		return synchronizedStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TagElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TagElementItemProvider tagElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TagElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTagElementAdapter() {
		if (tagElementItemProvider == null) {
			tagElementItemProvider = new TagElementItemProvider(this);
		}

		return tagElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TextElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TextElementItemProvider textElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TextElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTextElementAdapter() {
		if (textElementItemProvider == null) {
			textElementItemProvider = new TextElementItemProvider(this);
		}

		return textElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ThisExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThisExpressionItemProvider thisExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ThisExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThisExpressionAdapter() {
		if (thisExpressionItemProvider == null) {
			thisExpressionItemProvider = new ThisExpressionItemProvider(this);
		}

		return thisExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.ThrowStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThrowStatementItemProvider throwStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.ThrowStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThrowStatementAdapter() {
		if (throwStatementItemProvider == null) {
			throwStatementItemProvider = new ThrowStatementItemProvider(this);
		}

		return throwStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TryStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TryStatementItemProvider tryStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TryStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTryStatementAdapter() {
		if (tryStatementItemProvider == null) {
			tryStatementItemProvider = new TryStatementItemProvider(this);
		}

		return tryStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TypeAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeAccessItemProvider typeAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeAccessAdapter() {
		if (typeAccessItemProvider == null) {
			typeAccessItemProvider = new TypeAccessItemProvider(this);
		}

		return typeAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TypeDeclarationStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeDeclarationStatementItemProvider typeDeclarationStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TypeDeclarationStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeDeclarationStatementAdapter() {
		if (typeDeclarationStatementItemProvider == null) {
			typeDeclarationStatementItemProvider = new TypeDeclarationStatementItemProvider(this);
		}

		return typeDeclarationStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TypeLiteral} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeLiteralItemProvider typeLiteralItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TypeLiteral}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeLiteralAdapter() {
		if (typeLiteralItemProvider == null) {
			typeLiteralItemProvider = new TypeLiteralItemProvider(this);
		}

		return typeLiteralItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.TypeParameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeParameterItemProvider typeParameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.TypeParameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeParameterAdapter() {
		if (typeParameterItemProvider == null) {
			typeParameterItemProvider = new TypeParameterItemProvider(this);
		}

		return typeParameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedItem} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedItemItemProvider unresolvedItemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedItem}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedItemAdapter() {
		if (unresolvedItemItemProvider == null) {
			unresolvedItemItemProvider = new UnresolvedItemItemProvider(this);
		}

		return unresolvedItemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedItemAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedItemAccessItemProvider unresolvedItemAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedItemAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedItemAccessAdapter() {
		if (unresolvedItemAccessItemProvider == null) {
			unresolvedItemAccessItemProvider = new UnresolvedItemAccessItemProvider(this);
		}

		return unresolvedItemAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedAnnotationDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedAnnotationDeclarationItemProvider unresolvedAnnotationDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedAnnotationDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedAnnotationDeclarationAdapter() {
		if (unresolvedAnnotationDeclarationItemProvider == null) {
			unresolvedAnnotationDeclarationItemProvider = new UnresolvedAnnotationDeclarationItemProvider(this);
		}

		return unresolvedAnnotationDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedAnnotationTypeMemberDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedAnnotationTypeMemberDeclarationItemProvider unresolvedAnnotationTypeMemberDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedAnnotationTypeMemberDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedAnnotationTypeMemberDeclarationAdapter() {
		if (unresolvedAnnotationTypeMemberDeclarationItemProvider == null) {
			unresolvedAnnotationTypeMemberDeclarationItemProvider = new UnresolvedAnnotationTypeMemberDeclarationItemProvider(this);
		}

		return unresolvedAnnotationTypeMemberDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedClassDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedClassDeclarationItemProvider unresolvedClassDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedClassDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedClassDeclarationAdapter() {
		if (unresolvedClassDeclarationItemProvider == null) {
			unresolvedClassDeclarationItemProvider = new UnresolvedClassDeclarationItemProvider(this);
		}

		return unresolvedClassDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedEnumDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedEnumDeclarationItemProvider unresolvedEnumDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedEnumDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedEnumDeclarationAdapter() {
		if (unresolvedEnumDeclarationItemProvider == null) {
			unresolvedEnumDeclarationItemProvider = new UnresolvedEnumDeclarationItemProvider(this);
		}

		return unresolvedEnumDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedInterfaceDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedInterfaceDeclarationItemProvider unresolvedInterfaceDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedInterfaceDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedInterfaceDeclarationAdapter() {
		if (unresolvedInterfaceDeclarationItemProvider == null) {
			unresolvedInterfaceDeclarationItemProvider = new UnresolvedInterfaceDeclarationItemProvider(this);
		}

		return unresolvedInterfaceDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedLabeledStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedLabeledStatementItemProvider unresolvedLabeledStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedLabeledStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedLabeledStatementAdapter() {
		if (unresolvedLabeledStatementItemProvider == null) {
			unresolvedLabeledStatementItemProvider = new UnresolvedLabeledStatementItemProvider(this);
		}

		return unresolvedLabeledStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedMethodDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedMethodDeclarationItemProvider unresolvedMethodDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedMethodDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedMethodDeclarationAdapter() {
		if (unresolvedMethodDeclarationItemProvider == null) {
			unresolvedMethodDeclarationItemProvider = new UnresolvedMethodDeclarationItemProvider(this);
		}

		return unresolvedMethodDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedSingleVariableDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedSingleVariableDeclarationItemProvider unresolvedSingleVariableDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedSingleVariableDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedSingleVariableDeclarationAdapter() {
		if (unresolvedSingleVariableDeclarationItemProvider == null) {
			unresolvedSingleVariableDeclarationItemProvider = new UnresolvedSingleVariableDeclarationItemProvider(this);
		}

		return unresolvedSingleVariableDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedTypeItemProvider unresolvedTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedTypeAdapter() {
		if (unresolvedTypeItemProvider == null) {
			unresolvedTypeItemProvider = new UnresolvedTypeItemProvider(this);
		}

		return unresolvedTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedTypeDeclaration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedTypeDeclarationItemProvider unresolvedTypeDeclarationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedTypeDeclaration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedTypeDeclarationAdapter() {
		if (unresolvedTypeDeclarationItemProvider == null) {
			unresolvedTypeDeclarationItemProvider = new UnresolvedTypeDeclarationItemProvider(this);
		}

		return unresolvedTypeDeclarationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.UnresolvedVariableDeclarationFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UnresolvedVariableDeclarationFragmentItemProvider unresolvedVariableDeclarationFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.UnresolvedVariableDeclarationFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUnresolvedVariableDeclarationFragmentAdapter() {
		if (unresolvedVariableDeclarationFragmentItemProvider == null) {
			unresolvedVariableDeclarationFragmentItemProvider = new UnresolvedVariableDeclarationFragmentItemProvider(this);
		}

		return unresolvedVariableDeclarationFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.VariableDeclarationExpression} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableDeclarationExpressionItemProvider variableDeclarationExpressionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.VariableDeclarationExpression}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableDeclarationExpressionAdapter() {
		if (variableDeclarationExpressionItemProvider == null) {
			variableDeclarationExpressionItemProvider = new VariableDeclarationExpressionItemProvider(this);
		}

		return variableDeclarationExpressionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.VariableDeclarationFragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableDeclarationFragmentItemProvider variableDeclarationFragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.VariableDeclarationFragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableDeclarationFragmentAdapter() {
		if (variableDeclarationFragmentItemProvider == null) {
			variableDeclarationFragmentItemProvider = new VariableDeclarationFragmentItemProvider(this);
		}

		return variableDeclarationFragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.VariableDeclarationStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VariableDeclarationStatementItemProvider variableDeclarationStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.VariableDeclarationStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVariableDeclarationStatementAdapter() {
		if (variableDeclarationStatementItemProvider == null) {
			variableDeclarationStatementItemProvider = new VariableDeclarationStatementItemProvider(this);
		}

		return variableDeclarationStatementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.WildCardType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WildCardTypeItemProvider wildCardTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.WildCardType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWildCardTypeAdapter() {
		if (wildCardTypeItemProvider == null) {
			wildCardTypeItemProvider = new WildCardTypeItemProvider(this);
		}

		return wildCardTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmt.modisco.java.WhileStatement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected WhileStatementItemProvider whileStatementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.gmt.modisco.java.WhileStatement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWhileStatementAdapter() {
		if (whileStatementItemProvider == null) {
			whileStatementItemProvider = new WhileStatementItemProvider(this);
		}

		return whileStatementItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (annotationItemProvider != null) annotationItemProvider.dispose();
		if (archiveItemProvider != null) archiveItemProvider.dispose();
		if (assertStatementItemProvider != null) assertStatementItemProvider.dispose();
		if (annotationMemberValuePairItemProvider != null) annotationMemberValuePairItemProvider.dispose();
		if (annotationTypeDeclarationItemProvider != null) annotationTypeDeclarationItemProvider.dispose();
		if (annotationTypeMemberDeclarationItemProvider != null) annotationTypeMemberDeclarationItemProvider.dispose();
		if (anonymousClassDeclarationItemProvider != null) anonymousClassDeclarationItemProvider.dispose();
		if (arrayAccessItemProvider != null) arrayAccessItemProvider.dispose();
		if (arrayCreationItemProvider != null) arrayCreationItemProvider.dispose();
		if (arrayInitializerItemProvider != null) arrayInitializerItemProvider.dispose();
		if (arrayLengthAccessItemProvider != null) arrayLengthAccessItemProvider.dispose();
		if (arrayTypeItemProvider != null) arrayTypeItemProvider.dispose();
		if (assignmentItemProvider != null) assignmentItemProvider.dispose();
		if (booleanLiteralItemProvider != null) booleanLiteralItemProvider.dispose();
		if (blockCommentItemProvider != null) blockCommentItemProvider.dispose();
		if (blockItemProvider != null) blockItemProvider.dispose();
		if (breakStatementItemProvider != null) breakStatementItemProvider.dispose();
		if (castExpressionItemProvider != null) castExpressionItemProvider.dispose();
		if (catchClauseItemProvider != null) catchClauseItemProvider.dispose();
		if (characterLiteralItemProvider != null) characterLiteralItemProvider.dispose();
		if (classFileItemProvider != null) classFileItemProvider.dispose();
		if (classInstanceCreationItemProvider != null) classInstanceCreationItemProvider.dispose();
		if (constructorDeclarationItemProvider != null) constructorDeclarationItemProvider.dispose();
		if (conditionalExpressionItemProvider != null) conditionalExpressionItemProvider.dispose();
		if (constructorInvocationItemProvider != null) constructorInvocationItemProvider.dispose();
		if (classDeclarationItemProvider != null) classDeclarationItemProvider.dispose();
		if (compilationUnitItemProvider != null) compilationUnitItemProvider.dispose();
		if (continueStatementItemProvider != null) continueStatementItemProvider.dispose();
		if (doStatementItemProvider != null) doStatementItemProvider.dispose();
		if (emptyStatementItemProvider != null) emptyStatementItemProvider.dispose();
		if (enhancedForStatementItemProvider != null) enhancedForStatementItemProvider.dispose();
		if (enumConstantDeclarationItemProvider != null) enumConstantDeclarationItemProvider.dispose();
		if (enumDeclarationItemProvider != null) enumDeclarationItemProvider.dispose();
		if (expressionStatementItemProvider != null) expressionStatementItemProvider.dispose();
		if (fieldAccessItemProvider != null) fieldAccessItemProvider.dispose();
		if (fieldDeclarationItemProvider != null) fieldDeclarationItemProvider.dispose();
		if (forStatementItemProvider != null) forStatementItemProvider.dispose();
		if (ifStatementItemProvider != null) ifStatementItemProvider.dispose();
		if (importDeclarationItemProvider != null) importDeclarationItemProvider.dispose();
		if (infixExpressionItemProvider != null) infixExpressionItemProvider.dispose();
		if (initializerItemProvider != null) initializerItemProvider.dispose();
		if (instanceofExpressionItemProvider != null) instanceofExpressionItemProvider.dispose();
		if (interfaceDeclarationItemProvider != null) interfaceDeclarationItemProvider.dispose();
		if (javadocItemProvider != null) javadocItemProvider.dispose();
		if (labeledStatementItemProvider != null) labeledStatementItemProvider.dispose();
		if (lineCommentItemProvider != null) lineCommentItemProvider.dispose();
		if (manifestItemProvider != null) manifestItemProvider.dispose();
		if (manifestAttributeItemProvider != null) manifestAttributeItemProvider.dispose();
		if (manifestEntryItemProvider != null) manifestEntryItemProvider.dispose();
		if (memberRefItemProvider != null) memberRefItemProvider.dispose();
		if (methodDeclarationItemProvider != null) methodDeclarationItemProvider.dispose();
		if (methodInvocationItemProvider != null) methodInvocationItemProvider.dispose();
		if (methodRefItemProvider != null) methodRefItemProvider.dispose();
		if (methodRefParameterItemProvider != null) methodRefParameterItemProvider.dispose();
		if (modelItemProvider != null) modelItemProvider.dispose();
		if (modifierItemProvider != null) modifierItemProvider.dispose();
		if (numberLiteralItemProvider != null) numberLiteralItemProvider.dispose();
		if (nullLiteralItemProvider != null) nullLiteralItemProvider.dispose();
		if (packageItemProvider != null) packageItemProvider.dispose();
		if (packageAccessItemProvider != null) packageAccessItemProvider.dispose();
		if (parameterizedTypeItemProvider != null) parameterizedTypeItemProvider.dispose();
		if (parenthesizedExpressionItemProvider != null) parenthesizedExpressionItemProvider.dispose();
		if (postfixExpressionItemProvider != null) postfixExpressionItemProvider.dispose();
		if (prefixExpressionItemProvider != null) prefixExpressionItemProvider.dispose();
		if (primitiveTypeItemProvider != null) primitiveTypeItemProvider.dispose();
		if (primitiveTypeBooleanItemProvider != null) primitiveTypeBooleanItemProvider.dispose();
		if (primitiveTypeByteItemProvider != null) primitiveTypeByteItemProvider.dispose();
		if (primitiveTypeCharItemProvider != null) primitiveTypeCharItemProvider.dispose();
		if (primitiveTypeDoubleItemProvider != null) primitiveTypeDoubleItemProvider.dispose();
		if (primitiveTypeShortItemProvider != null) primitiveTypeShortItemProvider.dispose();
		if (primitiveTypeFloatItemProvider != null) primitiveTypeFloatItemProvider.dispose();
		if (primitiveTypeIntItemProvider != null) primitiveTypeIntItemProvider.dispose();
		if (primitiveTypeLongItemProvider != null) primitiveTypeLongItemProvider.dispose();
		if (primitiveTypeVoidItemProvider != null) primitiveTypeVoidItemProvider.dispose();
		if (returnStatementItemProvider != null) returnStatementItemProvider.dispose();
		if (singleVariableAccessItemProvider != null) singleVariableAccessItemProvider.dispose();
		if (singleVariableDeclarationItemProvider != null) singleVariableDeclarationItemProvider.dispose();
		if (stringLiteralItemProvider != null) stringLiteralItemProvider.dispose();
		if (superConstructorInvocationItemProvider != null) superConstructorInvocationItemProvider.dispose();
		if (superFieldAccessItemProvider != null) superFieldAccessItemProvider.dispose();
		if (superMethodInvocationItemProvider != null) superMethodInvocationItemProvider.dispose();
		if (switchCaseItemProvider != null) switchCaseItemProvider.dispose();
		if (switchStatementItemProvider != null) switchStatementItemProvider.dispose();
		if (synchronizedStatementItemProvider != null) synchronizedStatementItemProvider.dispose();
		if (tagElementItemProvider != null) tagElementItemProvider.dispose();
		if (textElementItemProvider != null) textElementItemProvider.dispose();
		if (thisExpressionItemProvider != null) thisExpressionItemProvider.dispose();
		if (throwStatementItemProvider != null) throwStatementItemProvider.dispose();
		if (tryStatementItemProvider != null) tryStatementItemProvider.dispose();
		if (typeAccessItemProvider != null) typeAccessItemProvider.dispose();
		if (typeDeclarationStatementItemProvider != null) typeDeclarationStatementItemProvider.dispose();
		if (typeLiteralItemProvider != null) typeLiteralItemProvider.dispose();
		if (typeParameterItemProvider != null) typeParameterItemProvider.dispose();
		if (unresolvedItemItemProvider != null) unresolvedItemItemProvider.dispose();
		if (unresolvedItemAccessItemProvider != null) unresolvedItemAccessItemProvider.dispose();
		if (unresolvedAnnotationDeclarationItemProvider != null) unresolvedAnnotationDeclarationItemProvider.dispose();
		if (unresolvedAnnotationTypeMemberDeclarationItemProvider != null) unresolvedAnnotationTypeMemberDeclarationItemProvider.dispose();
		if (unresolvedClassDeclarationItemProvider != null) unresolvedClassDeclarationItemProvider.dispose();
		if (unresolvedEnumDeclarationItemProvider != null) unresolvedEnumDeclarationItemProvider.dispose();
		if (unresolvedInterfaceDeclarationItemProvider != null) unresolvedInterfaceDeclarationItemProvider.dispose();
		if (unresolvedLabeledStatementItemProvider != null) unresolvedLabeledStatementItemProvider.dispose();
		if (unresolvedMethodDeclarationItemProvider != null) unresolvedMethodDeclarationItemProvider.dispose();
		if (unresolvedSingleVariableDeclarationItemProvider != null) unresolvedSingleVariableDeclarationItemProvider.dispose();
		if (unresolvedTypeItemProvider != null) unresolvedTypeItemProvider.dispose();
		if (unresolvedTypeDeclarationItemProvider != null) unresolvedTypeDeclarationItemProvider.dispose();
		if (unresolvedVariableDeclarationFragmentItemProvider != null) unresolvedVariableDeclarationFragmentItemProvider.dispose();
		if (variableDeclarationExpressionItemProvider != null) variableDeclarationExpressionItemProvider.dispose();
		if (variableDeclarationFragmentItemProvider != null) variableDeclarationFragmentItemProvider.dispose();
		if (variableDeclarationStatementItemProvider != null) variableDeclarationStatementItemProvider.dispose();
		if (wildCardTypeItemProvider != null) wildCardTypeItemProvider.dispose();
		if (whileStatementItemProvider != null) whileStatementItemProvider.dispose();
	}

}
