/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fujaba.commons.FujabaCommonsImages;
import org.fujaba.commons.console.IControllableReportListener;
import org.fujaba.commons.console.IProcessConsole;
import org.fujaba.commons.console.ProcessConsoleFactory;
import org.fujaba.commons.console.ProcessConsoleState;
import org.fujaba.commons.console.ReportLevel;
import org.fujaba.commons.console.internal.ProcessConsole;

public abstract class AbstractProcessConsoleJob
extends Job
implements IControllableReportListener {
    public static final String PREFIX_INFO = "INFO";
    public static final String PREFIX_DEBUG = "DEBUG";
    public static final String PREFIX_WARNING = "WARNING";
    public static final String PREFIX_ERROR = "ERROR";
    private final ProcessConsole console;
    private ReportLevel reportLevel;
    private final String description;
    private final ImageDescriptor image;

    public AbstractProcessConsoleJob(String category, String name, String description) {
        this(category, name, description, ReportLevel.INFO);
    }

    public AbstractProcessConsoleJob(String category, String name, String description, ReportLevel reportLevel) {
        this(category, name, description, FujabaCommonsImages.getDescriptor("icons/console/default.png"), reportLevel);
    }

    public AbstractProcessConsoleJob(String category, String name, String description, ImageDescriptor image) {
        this(category, name, description, image, ReportLevel.INFO);
    }

    public AbstractProcessConsoleJob(String category, String name, String description, ImageDescriptor image, ReportLevel reportLevel) {
        super(name);
        this.setUser(true);
        this.reportLevel = reportLevel;
        this.description = String.valueOf(category) + "_" + name + "_" + description;
        this.image = image;
        this.console = (ProcessConsole)ProcessConsoleFactory.createConsole(this);
    }

    public final IStatus run(IProgressMonitor monitor) {
        this.console.fireNewState(ProcessConsoleState.RUNNING);
        IStatus result = this.start(monitor);
        if (result == null) {
            result = Status.CANCEL_STATUS;
        }
        if (result.getSeverity() == 0) {
            this.console.fireNewState(ProcessConsoleState.FINISHED);
            monitor.done();
            return result;
        }
        this.console.fireNewState(ProcessConsoleState.ABORTED);
        monitor.done();
        return result;
    }

    public abstract IStatus start(IProgressMonitor var1);

    @Override
    public final IStatus error(String message, Object ... args) {
        this.console.error(String.format(message, args));
        return Status.CANCEL_STATUS;
    }

    @Override
    public final void warn(String message, Object ... args) {
        this.console.warn(String.format(message, args));
    }

    @Override
    public final void append(String message, Object ... args) {
        this.console.info(null, String.format(message, args));
    }

    @Override
    public final void task(String message, Object ... args) {
        if (ReportLevel.TASK.compareTo(this.reportLevel) <= 0) {
            this.console.info("TASK", String.valueOf(String.format(message, args)) + "...");
        }
    }

    @Override
    public final void info(String message, Object ... args) {
        if (ReportLevel.INFO.compareTo(this.reportLevel) <= 0) {
            this.console.info(String.format(message, args));
        }
    }

    @Override
    public final void debug(String message, Object ... args) {
        if (ReportLevel.DEBUG.compareTo(this.reportLevel) <= 0) {
            this.console.debug(String.format(message, args));
        }
    }

    @Override
    public final boolean isAborted() {
        return this.console.getProcessState().equals((Object)ProcessConsoleState.ABORTED);
    }

    @Override
    public final boolean isPaused() {
        return this.console.getProcessState().equals((Object)ProcessConsoleState.PAUSED);
    }

    protected final void canceling() {
        this.console.fireNewState(ProcessConsoleState.ABORTED);
    }

    @Override
    public final IProcessConsole getConsole() {
        return this.console;
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }
}

