/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.fujaba.commons.console.AbstractProcessConsoleJob;
import org.fujaba.commons.console.IProcessConsole;
import org.fujaba.commons.console.internal.ConsoleRemoveAllAction;
import org.fujaba.commons.console.internal.ProcessConsole;

public final class ProcessConsoleFactory
implements IConsoleFactory {
    private static final List<ProcessConsole> CONSOLES = new ArrayList<ProcessConsole>();

    public static boolean remove(ProcessConsole console) {
        if (console.canRemove()) {
            CONSOLES.remove(console);
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.removeConsoles(new IConsole[]{console});
            ProcessConsoleFactory.checkRemoveAllState();
            return true;
        }
        return false;
    }

    public static IProcessConsole createConsole(AbstractProcessConsoleJob job) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        ProcessConsole console = new ProcessConsole(job);
        CONSOLES.add(console);
        manager.addConsoles(new IConsole[]{console});
        return console;
    }

    public static boolean showConsole(ProcessConsole console) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = manager.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole existing = iConsoleArray[n2];
            if (existing.equals(console)) {
                manager.showConsoleView((IConsole)console);
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void removeAll() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = manager.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof ProcessConsole) {
                ProcessConsoleFactory.remove((ProcessConsole)console);
            }
            ++n2;
        }
    }

    public void openConsole() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) instanceof IConsoleView) {
            IConsole console = ((IConsoleView)part).getConsole();
            if (console instanceof ProcessConsole) {
                ProcessConsoleFactory.showConsole((ProcessConsole)console);
            } else if (!CONSOLES.isEmpty()) {
                ProcessConsoleFactory.showConsole(CONSOLES.get(CONSOLES.size() - 1));
            }
        }
    }

    public static void checkRemoveAllState() {
        boolean foundOne = false;
        for (ProcessConsole console : CONSOLES) {
            if (!console.canRemove()) continue;
            if (foundOne) {
                ConsoleRemoveAllAction.DEFAULT.setEnabled(true);
                return;
            }
            foundOne = true;
        }
        ConsoleRemoveAllAction.DEFAULT.setEnabled(false);
    }
}

