/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.console.internal;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.fujaba.commons.console.AbstractProcessConsoleJob;
import org.fujaba.commons.console.IProcessConsole;
import org.fujaba.commons.console.IProcessConsoleListener;
import org.fujaba.commons.console.ProcessConsoleFactory;
import org.fujaba.commons.console.ProcessConsoleState;

public class ProcessConsole
extends MessageConsole
implements IProcessConsole,
IProcessConsoleListener {
    private static final String CONSOLE_TYPE = "FujabaProcessConsole";
    private static final String TXT_ZERO = "0";
    private static final String TXT_EMPTY = " ";
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss,SSS");
    private final AbstractProcessConsoleJob job;
    private final Collection<IProcessConsoleListener> listeners;
    private final MessageConsoleStream infoStream;
    private final MessageConsoleStream debugStream;
    private final MessageConsoleStream warningStream;
    private final MessageConsoleStream errorStream;
    private ProcessConsoleState state;
    private int warned;
    private long started;
    private long paused;
    private long pauseDurance;

    private static String getName(ProcessConsole console) {
        StringBuilder name = new StringBuilder();
        switch (console.getProcessState()) {
            case IDLING: {
                name.append("<idling>");
                break;
            }
            case PAUSED: {
                name.append("<paused>");
                break;
            }
            case FINISHED: {
                name.append("<finished>");
                break;
            }
            case ABORTED: {
                name.append("<aborted>");
                break;
            }
        }
        name.append(console.getDescription());
        if (console.started > 0L) {
            Date started = new Date(console.started);
            name.append(TXT_EMPTY);
            name.append("(");
            name.append(DateFormat.getDateTimeInstance().format(started));
            name.append(")");
        }
        return name.toString();
    }

    private static String getSeconds(long millis) {
        long ms = millis % 1000L;
        long s = millis / 1000L % 60L;
        long m = millis / 60000L % 60L;
        long h = millis / 3600000L;
        StringBuilder durance = new StringBuilder();
        if (h < 10L) {
            durance.append(TXT_ZERO);
        }
        durance.append(h);
        durance.append(":");
        if (m < 10L) {
            durance.append(TXT_ZERO);
        }
        durance.append(m);
        durance.append(":");
        if (s < 10L) {
            durance.append(TXT_ZERO);
        }
        durance.append(s);
        durance.append(",");
        if (ms < 100L) {
            durance.append(TXT_ZERO);
        }
        if (ms < 10L) {
            durance.append(TXT_ZERO);
        }
        durance.append(ms);
        return durance.toString();
    }

    private static void print(MessageConsoleStream stream, String prefix, String message) {
        long time = System.currentTimeMillis();
        StringBuilder text = new StringBuilder();
        text.append(DATE_FORMATTER.format(new Date(time)));
        if (prefix != null) {
            text.append(TXT_EMPTY);
            text.append("[");
            text.append(prefix);
            text.append("]");
        }
        text.append(TXT_EMPTY);
        text.append(message);
        stream.println(text.toString());
    }

    public ProcessConsole(AbstractProcessConsoleJob job) {
        super(job.getDescription(), CONSOLE_TYPE, job.getImage(), true);
        this.job = job;
        this.infoStream = this.newMessageStream();
        this.infoStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 0, 0, 0));
        this.debugStream = this.newMessageStream();
        this.debugStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 120, 120, 120));
        this.warningStream = this.newMessageStream();
        this.warningStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 225, 150, 80));
        this.errorStream = this.newMessageStream();
        this.errorStream.setColor(new Color((Device)PlatformUI.getWorkbench().getDisplay(), 200, 30, 30));
        this.listeners = new ArrayList<IProcessConsoleListener>();
        this.addListener(this);
        this.fireNewState(ProcessConsoleState.IDLING);
    }

    @Override
    public boolean addListener(IProcessConsoleListener listener) {
        return this.listeners.add(listener);
    }

    public void fireNewState(ProcessConsoleState state) {
        for (IProcessConsoleListener listener : this.listeners) {
            listener.newState(state);
        }
    }

    protected void dispose() {
        this.listeners.clear();
        super.dispose();
    }

    public String getDescription() {
        return this.job.getDescription();
    }

    public ProcessConsoleState getProcessState() {
        return this.state;
    }

    public boolean canRemove() {
        switch (this.getProcessState()) {
            case RUNNING: 
            case PAUSED: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void newState(ProcessConsoleState state) {
        long current = System.currentTimeMillis();
        switch (state) {
            case IDLING: {
                ProcessConsole.print(this.infoStream, null, "The process has been created.");
                break;
            }
            case PAUSED: {
                this.paused = current;
                ProcessConsole.print(this.infoStream, null, "The process has been paused.");
                break;
            }
            case RUNNING: {
                if (this.paused > 0L) {
                    this.pauseDurance += current - this.paused;
                    this.paused = 0L;
                    ProcessConsole.print(this.infoStream, null, "The process has been resumed.");
                    break;
                }
                if (this.started != 0L) break;
                ProcessConsoleFactory.showConsole(this);
                this.started = current;
                ProcessConsole.print(this.infoStream, null, "The process has been started.");
                break;
            }
            case FINISHED: {
                if (this.warned > 0) {
                    if (this.pauseDurance > 0L) {
                        String message = "The process has been finished after %1$s (plus %2$s paused) with warnings (%3$s)!";
                        String running = ProcessConsole.getSeconds(current - this.started - this.pauseDurance);
                        String paused = ProcessConsole.getSeconds(this.pauseDurance);
                        ProcessConsole.print(this.warningStream, null, String.format(message, running, paused, this.warned));
                        break;
                    }
                    String message = "The process has been finished after %1$s with warnings (%2$s)!";
                    String running = ProcessConsole.getSeconds(current - this.started);
                    ProcessConsole.print(this.warningStream, null, String.format(message, running, this.warned));
                    break;
                }
                if (this.pauseDurance > 0L) {
                    String message = "The process has been finished after %1$s (plus %2$s paused).";
                    String running = ProcessConsole.getSeconds(current - this.started - this.pauseDurance);
                    String paused = ProcessConsole.getSeconds(this.pauseDurance);
                    ProcessConsole.print(this.infoStream, null, String.format(message, running, paused));
                    break;
                }
                String message = "The process has been finished after %1$s.";
                String running = ProcessConsole.getSeconds(current - this.started);
                ProcessConsole.print(this.infoStream, null, String.format(message, running));
                break;
            }
            case ABORTED: {
                if (this.warned > 0) {
                    if (this.pauseDurance > 0L) {
                        String message = "The process has been aborted after %1$s (plus %2$s paused) with warnings (%3$s)!";
                        String running = ProcessConsole.getSeconds(current - this.started - this.pauseDurance);
                        String paused = ProcessConsole.getSeconds(this.pauseDurance);
                        ProcessConsole.print(this.warningStream, null, String.format(message, running, paused, this.warned));
                        break;
                    }
                    String message = "The process has been aborted after %1$s with warnings (%2$s)!";
                    String running = ProcessConsole.getSeconds(current - this.started);
                    ProcessConsole.print(this.warningStream, null, String.format(message, running, this.warned));
                    break;
                }
                if (this.pauseDurance > 0L) {
                    String message = "The process has been aborted after %1$s (plus %2$s paused)!";
                    String running = ProcessConsole.getSeconds(current - this.started - this.pauseDurance);
                    String paused = ProcessConsole.getSeconds(this.pauseDurance);
                    ProcessConsole.print(this.warningStream, null, String.format(message, running, paused));
                    break;
                }
                String message = "The process has been aborted after %1$s!";
                String running = ProcessConsole.getSeconds(current - this.started);
                ProcessConsole.print(this.warningStream, null, String.format(message, running));
            }
        }
        this.state = state;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProcessConsole.this.setName(ProcessConsole.getName(ProcessConsole.this));
            }
        });
    }

    @Override
    public boolean removeListener(IProcessConsoleListener listener) {
        return this.listeners.remove(listener);
    }

    public void debug(String message) {
        this.debug("DEBUG", message);
    }

    public void debug(String prefix, String message) {
        ProcessConsole.print(this.debugStream, prefix, message);
    }

    public void info(String message) {
        this.info("INFO", message);
    }

    public void info(String prefix, String message) {
        ProcessConsole.print(this.infoStream, prefix, message);
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable throwable) {
        ProcessConsole.print(this.warningStream, "WARNING", message);
        if (throwable != null) {
            String detail = throwable.getMessage();
            ProcessConsole.print(this.warningStream, null, detail);
        }
        ++this.warned;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable throwable) {
        ProcessConsole.print(this.errorStream, "ERROR", message);
        if (throwable != null) {
            String detail = throwable.getMessage();
            ProcessConsole.print(this.errorStream, null, detail);
        }
    }
}

