/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.console.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.part.IPageBookViewPage;
import org.fujaba.commons.console.IProcessConsoleListener;
import org.fujaba.commons.console.ProcessConsoleFactory;
import org.fujaba.commons.console.ProcessConsoleState;
import org.fujaba.commons.console.internal.ConsoleAbortAction;
import org.fujaba.commons.console.internal.ConsolePauseAction;
import org.fujaba.commons.console.internal.ConsoleRemoveAction;
import org.fujaba.commons.console.internal.ConsoleRemoveAllAction;
import org.fujaba.commons.console.internal.ProcessConsole;

public final class ProcessConsoleProvider
implements IConsolePageParticipant,
IProcessConsoleListener {
    private ConsolePauseAction actionPause;
    private ConsoleAbortAction actionAbort;
    private ConsoleRemoveAction actionRemove;
    private ProcessConsole console;

    public void init(IPageBookViewPage page, IConsole console) {
        if (console instanceof ProcessConsole) {
            this.console = (ProcessConsole)console;
            this.console.addListener(this);
            this.actionPause = new ConsolePauseAction(this.console);
            this.actionAbort = new ConsoleAbortAction(this.console);
            this.actionRemove = new ConsoleRemoveAction(this.console);
            String group = "launchGroup";
            IToolBarManager mgr = page.getSite().getActionBars().getToolBarManager();
            mgr.appendToGroup(group, (IAction)this.actionPause);
            mgr.appendToGroup(group, (IAction)this.actionAbort);
            mgr.appendToGroup(group, (IAction)this.actionRemove);
            mgr.appendToGroup(group, (IAction)ConsoleRemoveAllAction.DEFAULT);
            this.newState(((ProcessConsole)console).getProcessState());
        }
    }

    @Override
    public void newState(ProcessConsoleState state) {
        switch (state) {
            case IDLING: 
            case FINISHED: 
            case ABORTED: {
                this.actionPause.setEnabled(false);
                this.actionAbort.setEnabled(false);
                this.actionRemove.setEnabled(true);
                break;
            }
            case RUNNING: 
            case PAUSED: {
                this.actionPause.setEnabled(true);
                this.actionAbort.setEnabled(true);
                this.actionRemove.setEnabled(false);
                break;
            }
        }
        ProcessConsoleFactory.checkRemoveAllState();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void dispose() {
        this.console.removeListener(this);
        this.actionAbort = null;
        this.actionPause = null;
        this.actionRemove = null;
        this.console = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }
}

