/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.edit.parts.AbstractEdgeViewEditPart;
import org.fujaba.commons.edit.policies.CommonBendPointEditPolicy;
import org.fujaba.commons.figures.utils.AdaptiveConnectionLocator;
import org.fujaba.commons.figures.utils.ConnectionDecorationFactory;
import org.fujaba.commons.notation.BendPoint;
import org.fujaba.commons.notation.Edge;
import org.fujaba.commons.notation.RelativeBendPoint;

public class AbstractEdgeEditPart
extends AbstractEdgeViewEditPart {
    protected ConnectionEndpointLocator leftLocator = null;
    protected ConnectionEndpointLocator rightLocator = null;
    protected Label relationshipLabel;
    protected PolygonDecoration readingDirectionArrow;
    private int readingDirection;
    protected PolylineConnection connection;

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new CommonBendPointEditPolicy());
    }

    protected IFigure createFigure() {
        this.connection = new PolylineConnection();
        this.setFigure((IFigure)this.connection);
        return this.figure;
    }

    @Override
    public void notifyChanged(Notification notification) {
        int featureID = notification.getFeatureID(Edge.class);
        if (9 == featureID || 10 == featureID || 4 == featureID || 11 == featureID) {
            this.refreshBendpoints();
        }
    }

    protected void placeLabel(String text) {
        this.placeLabel(text, 0);
    }

    protected void placeLabel(String text, int style) {
        this.placeLabel(text, style, null);
    }

    protected void placeLabel(String text, int style, ConnectionLocator locator) {
        if (this.relationshipLabel == null) {
            if (locator == null) {
                locator = new AdaptiveConnectionLocator((Connection)this.connection, 4, 6, 4);
                ((AdaptiveConnectionLocator)locator).setAxisBalance(0.75);
            }
            this.relationshipLabel = new Label(text);
            this.relationshipLabel.setTextAlignment(0x1000000);
            this.connection.add((IFigure)this.relationshipLabel, (Object)locator);
        } else {
            this.relationshipLabel.setText(text);
        }
        Font font = null;
        font = style == 1 ? Commons4EclipseFonts.getFont("org.fujaba.commons.FONT_BOLD") : (style == 2 ? Commons4EclipseFonts.getFont("org.fujaba.commons.FONT_ITALIC") : (style == 3 ? Commons4EclipseFonts.getFont("org.fujaba.commons.FONT_BOLD_ITALIC") : Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont")));
        this.relationshipLabel.setFont(font);
    }

    protected void placeReadingDirectionArrow(boolean toTarget) {
        this.placeReadingDirectionArrow(toTarget, ColorConstants.black, ColorConstants.black);
    }

    protected void placeReadingDirectionArrow(boolean toTarget, Color bg, Color fg) {
        int orientation;
        int n = orientation = toTarget ? 2 : 1;
        if (this.readingDirectionArrow == null || this.readingDirection != orientation) {
            this.readingDirection = orientation;
            AdaptiveConnectionLocator relationshipLocator = new AdaptiveConnectionLocator((Connection)this.connection, 4, 10, 5);
            relationshipLocator.setOrientation(orientation);
            relationshipLocator.setReference(1);
            relationshipLocator.setAxisBalance(0.75);
            if (this.readingDirectionArrow == null) {
                this.readingDirectionArrow = ConnectionDecorationFactory.createDecoration(4, bg, fg);
            }
            this.connection.add((IFigure)this.readingDirectionArrow, (Object)relationshipLocator);
        }
        this.readingDirectionArrow.setForegroundColor(fg);
        this.readingDirectionArrow.setBackgroundColor(bg);
    }

    protected void refreshBendpoints() {
        EList<BendPoint> bendpoints = this.getModel().getBendPoints();
        if (bendpoints == null || bendpoints.isEmpty()) {
            this.getConnectionFigure().setRoutingConstraint(Collections.emptyList());
            return;
        }
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int index = 0;
        for (BendPoint bp : bendpoints) {
            if (!(bp instanceof RelativeBendPoint)) continue;
            RelativeBendPoint wbp = (RelativeBendPoint)bp;
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(new Dimension(wbp.getSourceX(), wbp.getSourceY()), new Dimension(wbp.getTargetX(), wbp.getTargetY()));
            if (bendpoints.size() == 1) {
                rbp.setWeight(0.5f);
            } else {
                rbp.setWeight((float)index / ((float)bendpoints.size() - 1.0f));
            }
            figureConstraint.add(rbp);
            ++index;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    protected void refreshVisuals() {
        this.refreshBendpoints();
    }

    protected void removeLabel() {
        if (this.relationshipLabel != null) {
            this.connection.remove((IFigure)this.relationshipLabel);
            this.relationshipLabel = null;
        }
    }

    protected void removeReadingDirectionArrow() {
        if (this.readingDirectionArrow != null) {
            this.connection.remove((IFigure)this.readingDirectionArrow);
            this.readingDirectionArrow = null;
        }
    }
}

