/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.editor.AbstractSinglePageEditor;
import org.fujaba.commons.editor.DefaultContextMenuProvider;
import org.fujaba.commons.editor.palette.PaletteFactory;
import org.fujaba.commons.editor.palette.util.PaletteRootPreferenceUtil;
import org.fujaba.commons.extensionpoints.IPaletteExtension;
import org.fujaba.commons.extensionpoints.util.ExtensionpointTools;
import org.fujaba.commons.notation.HierarchicalNode;
import org.fujaba.commons.views.OverviewOutlinePage;

public abstract class AbstractSimpleEditorPart
extends AbstractSinglePageEditor
implements PropertyChangeListener {
    private DefaultEditDomain editDomain;
    private CommandStack commandStack;
    private GraphicalViewer graphicalViewer;
    private PaletteRoot paletteRoot;
    protected EditPartFactory editPartFactory;
    private DefaultContextMenuProvider contextMenuProvider;
    private HierarchicalNode diagram;
    private EObject diagramModel;
    private CTabItem ctabItem;
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private SelectionSynchronizer synchronizer;
    private OverviewOutlinePage overviewOutlinePage;
    protected KeyHandler sharedKeyHandler;
    protected PropertySheetPage propertySheetPage;

    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.createActions();
        this.createEditPartFactory();
    }

    protected abstract void createEditPartFactory();

    protected void createActions() {
        this.addCommandStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addCommandStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this));
        this.addEditorAction((EditorPartAction)new SaveAction((IEditorPart)this));
        this.addAction((IAction)new PrintAction((IWorkbenchPart)this));
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ScalableFreeformRootEditPart();
    }

    protected void configureGraphicalViewer() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.getControl().setBackground(ColorConstants.white);
        ScalableFreeformRootEditPart root = this.createRootEditPart();
        ConnectionLayer connectionLayer = (ConnectionLayer)root.getLayer((Object)"Connection Layer");
        connectionLayer.setAntialias(1);
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        IHandlerService service = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        service.activateHandler(zoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomIn));
        service.activateHandler(zoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)zoomOut));
        graphicalViewer.setRootEditPart((RootEditPart)root);
        this.getEditDomain().addViewer((EditPartViewer)graphicalViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)graphicalViewer);
        graphicalViewer.setEditPartFactory(this.getEditPartFactory());
        graphicalViewer.setContents((Object)this.getDiagram());
        this.contextMenuProvider = this.createContextMenuProvider(graphicalViewer, this.getActionRegistry());
        graphicalViewer.setContextMenu((MenuManager)this.contextMenuProvider);
        this.getSite().registerContextMenu(this.getId(), (MenuManager)this.contextMenuProvider, (ISelectionProvider)graphicalViewer);
        this.configureContextMenu(this.contextMenuProvider);
        graphicalViewer.setKeyHandler(new GraphicalViewerKeyHandler(graphicalViewer).setParent(this.getSharedKeyHandler()));
        ((FigureCanvas)graphicalViewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
    }

    protected DefaultContextMenuProvider createContextMenuProvider(GraphicalViewer graphicalViewer, ActionRegistry actionRegistry) {
        return new DefaultContextMenuProvider((EditPartViewer)graphicalViewer, actionRegistry);
    }

    protected void configureContextMenu(DefaultContextMenuProvider contextMenuProvider) {
    }

    protected KeyHandler getSharedKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        }
        return this.sharedKeyHandler;
    }

    protected EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            this.createEditPartFactory();
        }
        return this.editPartFactory;
    }

    public EditPart getEditPartOfFElement(EObject element) {
        return (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(element);
    }

    public HierarchicalNode getDiagram() {
        return this.diagram;
    }

    public void setDiagram(HierarchicalNode diagram) {
        this.diagram = diagram;
        this.setDiagramModel(diagram.getModel());
        this.setPartName(this.getEditorName());
        if (this.getGraphicalViewer() != null) {
            this.getGraphicalViewer().setContents((Object)diagram);
        }
    }

    protected String getEditorName() {
        String name = "Name: ";
        if (this.diagram.getModel() instanceof ENamedElement) {
            ENamedElement elem = (ENamedElement)this.diagram.getModel();
            name = String.valueOf(name) + elem.getName();
        } else {
            name = String.valueOf(name) + "N/A";
        }
        return name;
    }

    public EObject getDiagramModel() {
        return this.diagramModel;
    }

    public void setDiagramModel(EObject model) {
        this.diagramModel = model;
    }

    public EditDomain getEditDomain() {
        if (this.editDomain == null) {
            this.editDomain = new DefaultEditDomain((IEditorPart)this);
            this.setEditDomain(this.editDomain);
            this.editDomain.setCommandStack(this.getCommandStack());
        }
        return this.editDomain;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        this.editDomain = ed;
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    @Override
    public CommandStack getCommandStack() {
        if (this.commandStack != null) {
            return this.commandStack;
        }
        return this.getEditDomain().getCommandStack();
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected DefaultContextMenuProvider getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    protected IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage();
            this.propertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(this.getCommandStack()));
        }
        return this.propertySheetPage;
    }

    public IFile getEditorInputFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            ((IFileEditorInput)super.getEditorInput()).getFile();
        }
        return null;
    }

    protected abstract void performSaveAs(IFile var1);

    public void doSave(IProgressMonitor monitor) {
        this.performSaveAs(this.getEditorInputFile());
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(this.getEditorInputFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                AbstractSimpleEditorPart.this.performSaveAs(file);
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (InvocationTargetException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
        }
        this.getCommandStack().markSaveLocation();
    }

    public void setFocus() {
        GraphicalViewer gv = this.getGraphicalViewer();
        if (gv != null) {
            gv.getControl().setFocus();
        }
    }

    public void setCTabItem(CTabItem ctabItem) {
        this.ctabItem = ctabItem;
    }

    public CTabItem getCTabItem() {
        return this.ctabItem;
    }

    @Override
    public final void propertyChange(final PropertyChangeEvent event) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractSimpleEditorPart.this.isDisposed()) {
                        AbstractSimpleEditorPart.this.propertyChangeImpl(event);
                    }
                }
            });
        }
    }

    public void propertyChangeImpl(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName()) && this.getCTabItem() != null && !this.getCTabItem().isDisposed()) {
            String name = this.getEditorName();
            this.getCTabItem().setToolTipText(name);
            this.getCTabItem().setText(name);
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.createPalette();
        }
        return this.paletteRoot;
    }

    protected void setPaletteRoot(PaletteRoot value) {
        this.paletteRoot = value;
    }

    protected final PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                if (template instanceof CreationFactory) {
                    return (CreationFactory)template;
                }
                return new SimpleFactory(null);
            }
        };
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        this.splitter.hookDropTargetListener(graphicalViewer);
        graphicalViewer.addDropTargetListener(this.createTransferDropTargetListener());
    }

    protected abstract Image createEditorImage();

    protected void createPalette() {
        String editorClass = this.getClass().getName();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.fujaba.commons.palettes");
        IConfigurationElement elem = null;
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (editorClass.equals(element.getAttribute("editor"))) {
                elem = element;
                break;
            }
            ++n2;
        }
        if (elem == null) {
            FujabaCommonsPlugin.getDefault().logWarning("WARNING: editor '" + editorClass + "' doesn't use " + "the 'palettes'-extensionpoint to define the palette. Please " + "update the editor to use the 'palettes'-extensionpoint.");
            return;
        }
        IPaletteExtension factory = ExtensionpointTools.createFactory(elem, "factory", PaletteFactory.class);
        if (factory == null) {
            return;
        }
        PaletteRoot palette = factory.createPalette();
        this.setPaletteRoot(palette);
    }

    public void createPartControl(Composite parent) {
        this.splitter = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), PaletteRootPreferenceUtil.getPreferences());
        this.createGraphicalViewer((Composite)this.splitter);
        this.splitter.setGraphicalControl(this.getGraphicalViewer().getControl());
        this.setTitleImage(this.createEditorImage());
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider(this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    protected OverviewOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if (this.overviewOutlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.overviewOutlinePage = new OverviewOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.overviewOutlinePage;
    }

    protected class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (AbstractSimpleEditorPart.this.splitter != null) {
                AbstractSimpleEditorPart.this.splitter.setExternalViewer(this.viewer);
            }
        }

        public void dispose() {
            if (AbstractSimpleEditorPart.this.splitter != null) {
                AbstractSimpleEditorPart.this.splitter.setExternalViewer(null);
            }
            super.dispose();
        }

        public PaletteViewer getPaletteViewer() {
            return this.viewer;
        }
    }
}

