/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor;

import java.util.Iterator;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CommonSinglePageEditorActionBarContributor
extends EditorActionBarContributor {
    private ZoomComboContributionItem zoomComboContributionItem = null;

    public void setActiveEditor(IEditorPart activeEditor) {
        if (activeEditor != null) {
            ActionRegistry registry = (ActionRegistry)activeEditor.getAdapter(ActionRegistry.class);
            Iterator iter = registry.getActions();
            IActionBars bars = this.getActionBars();
            while (iter.hasNext()) {
                IAction action = (IAction)iter.next();
                bars.setGlobalActionHandler(action.getId(), action);
            }
            if (this.zoomComboContributionItem != null) {
                this.zoomComboContributionItem.setZoomManager((ZoomManager)activeEditor.getAdapter(ZoomManager.class));
            }
            bars.updateActionBars();
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IAction)ActionFactory.UNDO.create(this.getPage().getWorkbenchWindow()));
        toolBarManager.add((IAction)ActionFactory.REDO.create(this.getPage().getWorkbenchWindow()));
        toolBarManager.add((IContributionItem)new Separator());
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        this.zoomComboContributionItem = new ZoomComboContributionItem((IPartService)this.getPage(), zoomStrings);
        toolBarManager.add((IContributionItem)this.zoomComboContributionItem);
        toolBarManager.add((IContributionItem)new Separator());
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager viewMenu = new MenuManager("View");
        menuManager.insertAfter("edit", (IContributionItem)viewMenu);
    }
}

