/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.overviewpage;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.editor.AbstractPersistableModelViewMultiPageEditor;

public abstract class AbstractDiagramsSectionPart
extends SectionPart
implements Adapter {
    protected AbstractPersistableModelViewMultiPageEditor editor;
    protected String sectionName = "Contained Diagrams";
    protected String deleteConfirmQuestion = "Are you sure that you want to delete this diagram?";
    protected String chooseANameMsg = "Choose a name for your new diagram.";
    protected String newDiagramDefaultName = "New Diagram";

    public AbstractDiagramsSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit) {
        this(editor, parent, toolkit, null, null, null, null);
    }

    public AbstractDiagramsSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit, String sectionName, String deleteConfirmQuestion, String chooseANameMsg, String newDiagramDefaultName) {
        super(toolkit.createSection(parent, 322));
        this.editor = editor;
        this.sectionName = sectionName != null ? sectionName : this.sectionName;
        this.deleteConfirmQuestion = deleteConfirmQuestion != null ? deleteConfirmQuestion : this.deleteConfirmQuestion;
        this.chooseANameMsg = chooseANameMsg != null ? chooseANameMsg : this.chooseANameMsg;
        this.newDiagramDefaultName = newDiagramDefaultName != null ? newDiagramDefaultName : this.newDiagramDefaultName;
        this.createSectionContent(toolkit);
    }

    protected abstract void createSectionContent(FormToolkit var1);

    protected void addButtonPressed(SelectionEvent e) {
        InputDialog dialog = new InputDialog(this.getSection().getShell(), "Choose a name", this.chooseANameMsg, this.newDiagramDefaultName, null);
        int pressed = dialog.open();
        if (pressed == 0) {
            this.executeCommand(this.createAddDiagramCommand(dialog.getValue()));
        }
    }

    protected void removeButtonPressed(SelectionEvent e) {
        if (!MessageDialog.openConfirm((Shell)this.getSection().getShell(), (String)"Confirm", (String)this.deleteConfirmQuestion)) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand();
        EObject[] items = this.getSelection();
        int i = 0;
        while (i < items.length) {
            EObject diagramRoot = items[i];
            Command command = this.createDeleteDiagramCommandFor(diagramRoot);
            cmd.add(command);
            ++i;
        }
        this.executeCommand(cmd.unwrap());
    }

    protected void openButtonPressed() {
        EObject[] items = this.getSelection();
        int i = 0;
        while (i < items.length) {
            EObject diagramRoot = items[i];
            this.openDiagramFor(diagramRoot);
            ++i;
        }
    }

    protected abstract EObject[] getSelection();

    protected void executeCommand(Command cmd) {
        this.editor.getCommandStack().execute(cmd);
    }

    protected abstract Command createAddDiagramCommand(String var1);

    protected abstract Command createDeleteDiagramCommandFor(EObject var1);

    protected abstract void openDiagramFor(EObject var1);

    public void notifyChanged(Notification notification) {
        this.safeRefresh();
    }

    protected void safeRefresh() {
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractDiagramsSectionPart.this.refresh();
                }
            });
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }
}

