/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.overviewpage;

import java.beans.PropertyChangeEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.edit.commands.SetNameCommand;
import org.fujaba.commons.editor.AbstractMultiPageEditor;

public class NameSectionPart
extends SectionPart
implements Adapter {
    private AbstractMultiPageEditor editor;
    private ENamedElement namedElement;
    private Text nameField;

    public NameSectionPart(AbstractMultiPageEditor editor, Composite parent, FormToolkit toolkit) {
        super(toolkit.createSection(parent, 322));
        this.editor = editor;
        this.getSection().setText("Name");
        Composite nameComposite = toolkit.createComposite((Composite)this.getSection());
        nameComposite.setLayout((Layout)new GridLayout(2, false));
        this.nameField = toolkit.createText(nameComposite, "");
        GridData data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.getSection().setClient((Control)nameComposite);
        this.nameField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                NameSectionPart.this.keyReleaseOccured(e);
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NameSectionPart.this.editOccured();
            }
        });
        this.nameField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NameSectionPart.this.isDirty()) {
                    NameSectionPart.this.commit(false);
                }
            }
        });
    }

    void editOccured() {
        this.markDirty();
    }

    void keyReleaseOccured(KeyEvent e) {
        if (e.character == '\u001b') {
            this.refresh();
        }
    }

    public void commit(boolean onSave) {
        if (this.namedElement != null) {
            SetNameCommand cmd = new SetNameCommand(this.namedElement, this.nameField.getText());
            this.editor.getCommandStack().execute((Command)cmd);
        }
        super.commit(onSave);
    }

    public void refresh() {
        if (this.namedElement != null) {
            this.nameField.setText(this.namedElement.getName());
        }
        super.refresh();
    }

    public boolean setFormInput(Object input) {
        if (this.namedElement != null && this.namedElement != input) {
            this.namedElement.eAdapters().remove((Object)this);
        }
        if (input instanceof ENamedElement) {
            this.namedElement = (ENamedElement)input;
            this.namedElement.eAdapters().add((Object)this);
            this.safeRefresh();
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        this.safeRefresh();
    }

    protected void safeRefresh() {
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NameSectionPart.this.refresh();
                }
            });
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        this.safeRefresh();
    }

    public void setTarget(Notifier newTarget) {
    }
}

