/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.overviewpage;

import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.editor.AbstractPersistableModelViewMultiPageEditor;
import org.fujaba.commons.editor.overviewpage.AbstractDiagramsSectionPart;
import org.fujaba.commons.identifier.Identifier;

public abstract class NestedDiagramsSectionPart
extends AbstractDiagramsSectionPart {
    private EObject rootElement;
    private Button removeButton;
    private Table table;

    public NestedDiagramsSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit) {
        this(editor, parent, toolkit, null, null, null, null);
    }

    public NestedDiagramsSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit, String sectionName, String deleteConfirmQuestion, String chooseANameMsg, String newDiagramDefaultName) {
        super(editor, parent, toolkit, sectionName, deleteConfirmQuestion, chooseANameMsg, newDiagramDefaultName);
    }

    @Override
    protected void createSectionContent(FormToolkit toolkit) {
        this.getSection().setText(this.sectionName);
        Composite sectionClient = toolkit.createComposite((Composite)this.getSection());
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        this.table = toolkit.createTable(sectionClient, 2);
        GridData gridData = new GridData(1808);
        this.table.setLayoutData((Object)gridData);
        this.getSection().setClient((Control)sectionClient);
        Composite buttonComposite = new Composite(sectionClient, 0);
        buttonComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.verticalAlignment = 128;
        buttonComposite.setLayoutData((Object)data);
        Button addButton = toolkit.createButton(buttonComposite, "Add...", 0);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsSectionPart.this.addButtonPressed(e);
            }
        });
        data = new GridData(768);
        data.verticalAlignment = 128;
        addButton.setLayoutData((Object)data);
        this.removeButton = toolkit.createButton(buttonComposite, "Remove", 0);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsSectionPart.this.removeButtonPressed(e);
            }
        });
        data = new GridData(768);
        data.verticalAlignment = 128;
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        TableSelectionListener listener = new TableSelectionListener(this.table, this.removeButton);
        this.table.addSelectionListener((SelectionListener)listener);
        Button openButton = toolkit.createButton(buttonComposite, "Open", 0);
        data = new GridData(768);
        data.verticalAlignment = 128;
        openButton.setLayoutData((Object)data);
        openButton.setEnabled(false);
        openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsSectionPart.this.openButtonPressed();
            }
        });
        listener = new TableSelectionListener(this.table, openButton);
        this.table.addSelectionListener((SelectionListener)listener);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                NestedDiagramsSectionPart.this.openButtonPressed();
            }
        });
    }

    @Override
    protected EObject[] getSelection() {
        TableItem[] items = this.table.getSelection();
        EObject[] eItems = new EObject[items.length];
        int i = 0;
        while (i < items.length) {
            eItems[i] = (EObject)items[i].getData();
            ++i;
        }
        return eItems;
    }

    public void refresh() {
        this.table.removeAll();
        if (this.rootElement != null) {
            for (EObject eObject : this.getDiagramElements()) {
                this.addTreeItem(eObject);
            }
        }
        super.refresh();
    }

    protected abstract List<? extends EObject> getDiagramElements();

    protected TableItem addTreeItem(EObject element) {
        TableItem item = new TableItem(this.table, 0);
        item.setData((Object)element);
        if (element instanceof ENamedElement) {
            item.setText(((ENamedElement)element).getName());
        } else if (element instanceof Identifier) {
            item.setText(((Identifier)element).getName());
        } else {
            item.setText(element.toString());
        }
        return item;
    }

    @Override
    protected void addButtonPressed(SelectionEvent e) {
        InputDialog dialog = new InputDialog(this.getSection().getShell(), "Choose a name", this.chooseANameMsg, this.newDiagramDefaultName, null);
        int pressed = dialog.open();
        if (pressed == 0) {
            this.executeCommand(this.createAddDiagramCommand(dialog.getValue()));
        }
    }

    @Override
    protected void removeButtonPressed(SelectionEvent e) {
        if (!MessageDialog.openConfirm((Shell)this.getSection().getShell(), (String)"Confirm", (String)this.deleteConfirmQuestion)) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand();
        TableItem[] items = this.table.getSelection();
        int i = 0;
        while (i < items.length) {
            EObject diagramRoot = (EObject)items[i].getData();
            Command command = this.createDeleteDiagramCommandFor(diagramRoot);
            cmd.add(command);
            ++i;
        }
        this.executeCommand(cmd.unwrap());
    }

    @Override
    protected void openButtonPressed() {
        TableItem[] items = this.table.getSelection();
        int i = 0;
        while (i < items.length) {
            EObject diagramRoot = (EObject)items[i].getData();
            this.openDiagramFor(diagramRoot);
            ++i;
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof EObject) {
            if (this.rootElement != null) {
                this.rootElement.eAdapters().remove((Object)this);
            }
            this.rootElement = (EObject)input;
            this.rootElement.eAdapters().add((Object)this);
        }
        return super.setFormInput(input);
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getDeleteConfirmQuestion() {
        return this.deleteConfirmQuestion;
    }

    public void setDeleteConfirmQuestion(String deleteConfirmQuestion) {
        this.deleteConfirmQuestion = deleteConfirmQuestion;
    }

    public String getChooseANameMsg() {
        return this.chooseANameMsg;
    }

    public void setChooseANameMsg(String chooseANameMsg) {
        this.chooseANameMsg = chooseANameMsg;
    }

    public String getNewDiagramDefaultName() {
        return this.newDiagramDefaultName;
    }

    public void setNewDiagramDefaultName(String newDiagramDefaultName) {
        this.newDiagramDefaultName = newDiagramDefaultName;
    }

    private class TableSelectionListener
    extends SelectionAdapter {
        private Table table;
        private Button button;

        public TableSelectionListener(Table table, Button button) {
            this.table = table;
            this.button = button;
        }

        public void widgetSelected(SelectionEvent e) {
            this.button.setEnabled(this.table.getSelectionCount() > 0);
        }
    }
}

