/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.overviewpage;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.fujaba.commons.editor.AbstractPersistableModelViewMultiPageEditor;
import org.fujaba.commons.editor.overviewpage.AbstractDiagramsSectionPart;

public abstract class NestedDiagramsTreeSectionPart
extends AbstractDiagramsSectionPart {
    private TreeViewer viewer;
    private Button removeButton;
    private Button openButton;
    private Button addButton;

    public NestedDiagramsTreeSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit) {
        this(editor, parent, toolkit, null, null, null, null);
    }

    public NestedDiagramsTreeSectionPart(AbstractPersistableModelViewMultiPageEditor editor, Composite parent, FormToolkit toolkit, String sectionName, String deleteConfirmQuestion, String chooseANameMsg, String newDiagramDefaultName) {
        super(editor, parent, toolkit, sectionName, deleteConfirmQuestion, chooseANameMsg, newDiagramDefaultName);
    }

    @Override
    protected void createSectionContent(FormToolkit toolkit) {
        Composite main = toolkit.createComposite((Composite)this.getSection());
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Tree tree = toolkit.createTree(main, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider(this.getLabelProvider());
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setAutoExpandLevel(-1);
        Composite buttons = toolkit.createComposite(main);
        GridDataFactory.fillDefaults().align(0x1000000, 128).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        this.addButton = toolkit.createButton(buttons, "Add", 8);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.addButton);
        this.removeButton = toolkit.createButton(buttons, "Remove", 8);
        this.removeButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.removeButton);
        this.openButton = toolkit.createButton(buttons, "Open", 8);
        this.openButton.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.openButton);
        this.hookControlListeners();
        this.getSection().setClient((Control)main);
    }

    @Override
    protected EObject[] getSelection() {
        Object selected;
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && !this.viewer.getSelection().isEmpty() && (selected = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement()) != null) {
            EObject[] items = new EObject[]{(EObject)((TreeNode)selected).getValue()};
            return items;
        }
        return new EObject[0];
    }

    private void hookControlListeners() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NestedDiagramsTreeSectionPart.this.openButtonPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NestedDiagramsTreeSectionPart.this.treeSelectionChanged();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsTreeSectionPart.this.addButtonPressed(e);
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsTreeSectionPart.this.removeButtonPressed(e);
            }
        });
        this.openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NestedDiagramsTreeSectionPart.this.openButtonPressed();
            }
        });
    }

    protected void treeSelectionChanged() {
        Object[] selected = this.getSelection();
        if (selected.length > 0) {
            this.editor.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(selected));
            this.openButton.setEnabled(true);
            boolean removable = this.canRemove((EObject[])selected);
            String text = null;
            if (!removable) {
                text = "The selected pattern is referenced anywhere.";
            }
            this.removeButton.setEnabled(removable);
            this.removeButton.setToolTipText(text);
        } else {
            this.removeButton.setEnabled(false);
            this.openButton.setEnabled(false);
        }
    }

    public void refresh() {
        super.refresh();
        this.viewer.setInput((Object)this.getInput());
        this.viewer.refresh();
    }

    protected abstract TreeNode createNode(EObject var1, TreeNode var2);

    protected abstract TreeNode[] getInput();

    protected boolean canRemove(EObject[] selected) {
        return true;
    }

    protected abstract IBaseLabelProvider getLabelProvider();

    protected abstract IContentProvider getContentProvider();
}

