/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.editor.palette;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.editor.palette.EObjectCreationFactory;
import org.fujaba.commons.extensionpoints.IPaletteEntryExtension;
import org.fujaba.commons.extensionpoints.util.ExtensionpointTools;
import org.osgi.framework.Bundle;

public class PaletteEntryFactory
implements IPaletteEntryExtension,
IExecutableExtension {
    private IConfigurationElement config;

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        this.config = configElement;
    }

    @Override
    public PaletteEntry createPaletteEntry() {
        Class product;
        Bundle bundle = Platform.getBundle((String)this.config.getContributor().getName());
        if (bundle == null) {
            return null;
        }
        try {
            product = bundle.loadClass(this.config.getAttribute("product"));
        }
        catch (ClassNotFoundException e) {
            FujabaCommonsPlugin.getDefault().logError(e.getMessage(), e);
            return null;
        }
        ImageDescriptor icon16 = ExtensionpointTools.getImage(this.config, "icon16");
        ImageDescriptor icon24 = ExtensionpointTools.getImage(this.config, "icon24", true);
        if (icon24 == null) {
            icon24 = icon16;
        }
        String label = this.config.getAttribute("label");
        String tooltip = this.config.getAttribute("tooltip");
        if (tooltip == null && label != null && label.length() > 0) {
            tooltip = "aAoOuUiI".contains(label.substring(0, 1)) ? "Create an " + label : "Create a " + label;
        }
        EObjectCreationFactory factory = new EObjectCreationFactory(product);
        if ("element".equals(this.config.getAttribute("type"))) {
            CreationToolEntry entry = new CreationToolEntry(label, tooltip, (CreationFactory)factory, icon16, icon24);
            return entry;
        }
        return new ConnectionCreationToolEntry(label, tooltip, (CreationFactory)factory, icon16, icon24);
    }
}

