/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.extensionpoints.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fujaba.commons.FujabaCommonsImages;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.utils.OrderedNode;
import org.fujaba.commons.utils.TopologicalOrder;

public class ExtensionpointTools {
    public static List<String> getSortedReferences(IConfigurationElement[] elems, String refAttr, String prevAttr, String nextAttr) {
        OrderedNode<IConfigurationElement> node;
        TopologicalOrder<IConfigurationElement> graph = ExtensionpointTools.createTopologicalOrder(elems, refAttr, prevAttr, nextAttr);
        ArrayList<String> result = new ArrayList<String>(graph.size());
        while ((node = graph.dequeue()) != null) {
            if (node.getElement() == null) continue;
            result.add(node.getId());
        }
        if (graph.size() != 0) {
            FujabaCommonsPlugin.getDefault().logError("The ordering of the following '" + refAttr + "'-references form a cycle!");
        }
        return result;
    }

    private static TopologicalOrder<IConfigurationElement> createTopologicalOrder(IConfigurationElement[] elements, String idAttr, String prevIdAttr, String nextIdAttr) {
        TopologicalOrder<IConfigurationElement> graph = new TopologicalOrder<IConfigurationElement>();
        ExtensionpointTools.addToTopologicalOrder(graph, elements, idAttr, prevIdAttr, nextIdAttr);
        return graph;
    }

    private static void addToTopologicalOrder(TopologicalOrder<IConfigurationElement> graph, IConfigurationElement[] elements, String idAttr, String prevIdAttr, String nextIdAttr) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            String id = elem.getAttribute(idAttr);
            OrderedNode<IConfigurationElement> node = ExtensionpointTools.getOrCreateNode(graph, id, elem);
            String prevIDs = elem.getAttribute(prevIdAttr);
            String[] stringArray = ExtensionpointTools.trimSplit(prevIDs);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String prevID = stringArray[n4];
                ExtensionpointTools.getOrCreateNode(graph, prevID, null).addToNext(node);
                ++n4;
            }
            String nextIDs = elem.getAttribute(nextIdAttr);
            String[] stringArray2 = ExtensionpointTools.trimSplit(nextIDs);
            int n5 = stringArray2.length;
            n3 = 0;
            while (n3 < n5) {
                String nextID = stringArray2[n3];
                ExtensionpointTools.getOrCreateNode(graph, nextID, null).addToPrevious(node);
                ++n3;
            }
            ++n2;
        }
    }

    private static <T> OrderedNode<T> getOrCreateNode(TopologicalOrder<T> graph, String id, T elem) {
        OrderedNode<T> node = graph.get(id);
        if (node == null) {
            node = new OrderedNode<T>(id, elem);
            graph.add(node);
        } else if (elem != null) {
            node.setElement(elem);
        }
        return node;
    }

    private static String[] trimSplit(String string) {
        return ExtensionpointTools.trimSplit(string, ";:,");
    }

    private static String[] trimSplit(String string, String sep) {
        if (string == null) {
            return new String[0];
        }
        String[] s = string.split(sep);
        int i = 0;
        while (i < s.length) {
            s[i] = s[i].trim();
            ++i;
        }
        return s;
    }

    public static List<IConfigurationElement> resolveReferences(List<String> refs, String attr, String extensionPointId) {
        return ExtensionpointTools.resolveReferences(refs, attr, extensionPointId, false);
    }

    private static List<IConfigurationElement> resolveReferences(List<String> refs, String attr, String extensionPointId, boolean allowNull) {
        IConfigurationElement[] elements;
        HashMap<String, IConfigurationElement> map = new HashMap<String, IConfigurationElement>(refs.size());
        for (String ref : refs) {
            map.put(ref, null);
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            String ref = elem.getAttribute(attr);
            if (map.containsKey(ref)) {
                map.put(ref, elem);
            }
            ++n2;
        }
        ArrayList<IConfigurationElement> elems = new ArrayList<IConfigurationElement>(refs.size());
        for (String ref : refs) {
            IConfigurationElement elem = (IConfigurationElement)map.get(ref);
            if (allowNull || elem != null) {
                elems.add(elem);
                continue;
            }
            throw new RuntimeException("unresolveable '" + extensionPointId + "' configuration element with '" + attr + "' == " + ref);
        }
        return elems;
    }

    public static IConfigurationElement resolveReference(String ref, String attr, String extensionPointId) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (ref.equals(elem.getAttribute(attr))) {
                return elem;
            }
            ++n2;
        }
        return null;
    }

    public static <T> List<T> createFactories(List<IConfigurationElement> elements, String factoryAttr, Class<? extends T> defaultFactory) {
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (IConfigurationElement elem : elements) {
            T factory = ExtensionpointTools.createFactory(elem, factoryAttr, defaultFactory);
            if (factory == null) continue;
            result.add(factory);
        }
        return result;
    }

    public static <T> T createFactory(IConfigurationElement elem, String factoryAttr, Class<? extends T> defaultFactory) {
        Object factory = null;
        if (elem.getAttribute(factoryAttr) != null) {
            try {
                factory = elem.createExecutableExtension(factoryAttr);
            }
            catch (CoreException exc) {
                FujabaCommonsPlugin.getDefault().logError(exc.getMessage(), exc);
            }
        }
        if (factory == null) {
            try {
                factory = defaultFactory.newInstance();
            }
            catch (InstantiationException exc) {
                FujabaCommonsPlugin.getDefault().logError(exc.getMessage(), exc);
            }
            catch (IllegalAccessException exc) {
                FujabaCommonsPlugin.getDefault().logError(exc.getMessage(), exc);
            }
            if (factory != null && factory instanceof IExecutableExtension) {
                try {
                    ((IExecutableExtension)factory).setInitializationData(elem, factoryAttr, null);
                }
                catch (CoreException exc) {
                    FujabaCommonsPlugin.getDefault().logError(exc.getMessage(), exc);
                }
            }
        }
        return (T)factory;
    }

    public static ImageDescriptor getImage(IConfigurationElement config, String attr) {
        return ExtensionpointTools.getImage(config, attr, false);
    }

    public static ImageDescriptor getImage(IConfigurationElement config, String attr, boolean allowNull) {
        ImageDescriptor img = FujabaCommonsImages.getOrCreateDescriptor(config.getContributor().getName(), config.getAttribute(attr));
        if (ImageDescriptor.getMissingImageDescriptor().equals(img)) {
            FujabaCommonsPlugin.getDefault().logWarning("WARNING: missing image used in palette entry '" + config.getAttribute("id") + "' of plugin '" + config.getContributor().getName() + "': " + config.getAttribute(attr));
            if (allowNull) {
                return null;
            }
        }
        return img;
    }

    public static <T> T[] joinArrays(T[] a1, T[] a2) {
        T t;
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        ArrayList<T> list = new ArrayList<T>(a1.length + a2.length);
        T[] TArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            t = TArray[n2];
            list.add(t);
            ++n2;
        }
        TArray = a2;
        n = a2.length;
        n2 = 0;
        while (n2 < n) {
            t = TArray[n2];
            list.add(t);
            ++n2;
        }
        Object[] result = list.toArray((Object[])a1.clone());
        return result;
    }
}

