/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.ILineBorder;

public abstract class AbstractLineBorder
extends AbstractBorder
implements ILineBorder {
    private Color color = ColorConstants.black;
    private int width = 1;
    private int lineStyle = 1;

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        try {
            if (this.getColor() != null) {
                graphics.setForegroundColor(this.getColor());
            }
            if (this.getLineStyle() != -1) {
                graphics.setLineStyle(this.getLineStyle());
            }
            if (this.getWidth() != -1) {
                graphics.setLineWidth(this.getWidth());
            }
            this.paintBorder(figure, graphics, insets);
        }
        finally {
            graphics.popState();
        }
    }

    public abstract void paintBorder(IFigure var1, Graphics var2, Insets var3);

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setLineStyle(int lineStyle) {
        if (lineStyle != 1 && lineStyle != 2 && lineStyle != 3 && lineStyle != 4 && lineStyle != 5) {
            throw new IllegalArgumentException("Illegal line style: " + lineStyle);
        }
        this.lineStyle = lineStyle;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isOpaque() {
        return true;
    }

    public Dimension getPreferredSize(IFigure fig) {
        Insets insets = this.getInsets(fig);
        return new Dimension(insets.getWidth(), insets.getHeight());
    }
}

