/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public class DoublePolylineConnection
extends PolylineConnection {
    private int lineDistance = 2;
    private PointList leftLinePointList = null;
    private PointList rightLinePointList = null;

    protected PointList getLeftLinePointList() {
        return this.leftLinePointList;
    }

    protected PointList getRightLinePointList() {
        return this.rightLinePointList;
    }

    public void setLineDistance(int distance) {
        this.lineDistance = distance;
    }

    public int getLineDistance() {
        return this.lineDistance;
    }

    protected void outlineShape(Graphics g) {
        this.updatePointLists();
        g.drawPolyline(this.leftLinePointList);
        g.drawPolyline(this.rightLinePointList);
    }

    protected void updatePointLists() {
        this.translatePointsToCreateADoubleLine(this.getPoints());
    }

    protected void translatePointsToCreateADoubleLine(PointList pointsRepresentingTheSingleLine) {
        this.leftLinePointList = pointsRepresentingTheSingleLine.getCopy();
        this.rightLinePointList = pointsRepresentingTheSingleLine.getCopy();
        int distance = this.getLineDistance();
        int i = 1;
        while (i < pointsRepresentingTheSingleLine.size()) {
            Point lastPoint = pointsRepresentingTheSingleLine.getPoint(i - 1);
            Point currentPoint = pointsRepresentingTheSingleLine.getPoint(i);
            double vectorLength = Math.sqrt((currentPoint.x - lastPoint.x) * (currentPoint.x - lastPoint.x) + (currentPoint.y - lastPoint.y) * (currentPoint.y - lastPoint.y));
            double deltaX = (double)(lastPoint.y - currentPoint.y) / vectorLength;
            double deltaY = (double)(currentPoint.x - lastPoint.x) / vectorLength;
            this.translateLineSegment(this.leftLinePointList, i, lastPoint, currentPoint, deltaX *= 0.5 * (double)distance + 0.5 * (double)this.getLineWidth(), deltaY *= 0.5 * (double)distance + 0.5 * (double)this.getLineWidth());
            this.translateLineSegment(this.rightLinePointList, i, lastPoint, currentPoint, -deltaX, -deltaY);
            ++i;
        }
    }

    private void translateLineSegment(PointList translatedPoints, int endPointIndex, Point startPoint, Point endPoint, double deltaX, double deltaY) {
        double cx = Math.round((double)startPoint.x + deltaX);
        double cy = Math.round((double)startPoint.y + deltaY);
        double dx = Math.round((double)endPoint.x + deltaX);
        double dy = Math.round((double)endPoint.y + deltaY);
        if (endPointIndex > 1) {
            double ax = translatedPoints.getPoint((int)(endPointIndex - 2)).x;
            double ay = translatedPoints.getPoint((int)(endPointIndex - 2)).y;
            double bx = translatedPoints.getPoint((int)(endPointIndex - 1)).x;
            double by = translatedPoints.getPoint((int)(endPointIndex - 1)).y;
            double lambda = (ax * by - ax * cy + ay * cx - ay * bx + bx * cy - by * cx) / ((dx - cx) * (by - ay) - (dy - cy) * (bx - ax));
            cx = Math.round(cx + lambda * (dx - cx));
            cy = Math.round(cy + lambda * (dy - cy));
        }
        translatedPoints.setPoint((Point)new PrecisionPoint(cx, cy), endPointIndex - 1);
        translatedPoints.setPoint((Point)new PrecisionPoint(dx, dy), endPointIndex);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.updatePointLists();
            this.bounds = this.leftLinePointList.getBounds().getExpanded(this.getLineWidth() / 2, this.getLineWidth() / 2);
            Rectangle boundsTemp = this.rightLinePointList.getBounds().getExpanded(this.getLineWidth() / 2, this.getLineWidth() / 2);
            this.bounds = this.bounds.union(boundsTemp);
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }
}

