/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.AbstractLineBorder;

public class EllipseBorder
extends AbstractLineBorder {
    public EllipseBorder() {
    }

    public EllipseBorder(int width) {
        this(null, width);
    }

    public EllipseBorder(Color color) {
        this(color, 1);
    }

    public EllipseBorder(Color color, int width) {
        this.setColor(color);
        this.setWidth(width);
    }

    public EllipseBorder(Color color, int width, int lineStyle) {
        this.setColor(color);
        this.setWidth(width);
        this.setLineStyle(lineStyle);
    }

    public Insets getInsets(IFigure figure) {
        Dimension size = figure.getSize();
        int semiMajorAxis = (int)Math.ceil((double)size.width / 2.0);
        int semiMinorAxis = (int)Math.ceil((double)size.height / 2.0);
        int linearEccentricity = (int)Math.ceil(Math.sqrt(semiMajorAxis * semiMajorAxis - semiMinorAxis * semiMinorAxis));
        int left = semiMajorAxis - linearEccentricity;
        int semiLatusRectum = (int)Math.ceil(semiMinorAxis * semiMinorAxis / semiMajorAxis);
        int top = semiMinorAxis - semiLatusRectum;
        return new Insets(top, left, top, left);
    }

    @Override
    public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle rect = EllipseBorder.getPaintRectangle((IFigure)figure, (Insets)insets);
        int width = figure.getBounds().width;
        int height = figure.getBounds().height;
        int x = rect.x + (int)Math.floor((double)this.getWidth() / 2.0);
        int y = rect.y + (int)Math.floor((double)this.getWidth() / 2.0);
        graphics.drawOval(x, y, width - this.getWidth(), height - this.getWidth());
    }
}

