/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.fujaba.commons.Commons4EclipseFonts;

public class LabelFigure
extends Label {
    private boolean underlined = false;
    private boolean underlineMultipleLines = true;
    private boolean autosized = false;

    public LabelFigure() {
        this.setFont(Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
    }

    public LabelFigure(String s) {
        this(s, Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
    }

    public LabelFigure(String s, Font font) {
        super(s);
        if (font != null) {
            this.setFont(font);
        } else {
            this.setFont(Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
        }
    }

    public LabelFigure(Image i) {
        super(i);
        this.setFont(Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
    }

    public LabelFigure(String s, Image i) {
        this(s, i, Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
    }

    public LabelFigure(String s, Image i, Font font) {
        super(s, i);
        if (font != null) {
            this.setFont(font);
        } else {
            this.setFont(Commons4EclipseFonts.getFont("org.eclipse.jface.defaultfont"));
        }
    }

    public String getName() {
        return this.getText();
    }

    public void setName(String name) {
        this.setText(name);
    }

    public void setText(String s) {
        super.setText(s);
        this.autosize();
    }

    public void setIcon(Image image) {
        super.setIcon(image);
        this.autosize();
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.repaint();
    }

    public boolean isAutosized() {
        return this.autosized;
    }

    public void setAutosized(boolean autosize) {
        this.autosized = autosize;
        this.autosize();
    }

    private void autosize() {
        if (this.autosized) {
            this.setSize(this.getPreferredSize());
        }
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlineMultipleLines(boolean underlineMultipleLines) {
        this.underlineMultipleLines = underlineMultipleLines;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.underlined) {
            Rectangle bounds = this.getBounds();
            graphics.translate(bounds.x, bounds.y);
            Dimension size = this.getSubStringTextSize();
            Point location = this.getTextLocation();
            if (this.underlineMultipleLines) {
                int lines = 1;
                int index = -1;
                String text = this.getName();
                while ((index = text.indexOf(System.getProperty("line.separator"))) != -1) {
                    ++lines;
                    text = text.substring(index + 1);
                }
                int lineCounter = 1;
                while (lineCounter < lines) {
                    graphics.drawLine(location.x, location.y + size.height * lineCounter / lines - 1, location.x + size.width, location.y + size.height * lineCounter / lines - 1);
                    ++lineCounter;
                }
            }
            graphics.drawLine(location.x, location.y + size.height - 1, location.x + size.width, location.y + size.height - 1);
            graphics.translate(-bounds.x, -bounds.y);
        }
    }

    protected Dimension getTextSize() {
        Dimension size = super.getTextSize().getCopy();
        if (!this.underlined) {
            return size.expand(2, 0);
        }
        return size.expand(2, 1);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }
}

