/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fujaba.commons.figures.LineBorderedEllipseFigure;

public class LineBorderedEllipseContainer
extends LineBorderedEllipseFigure {
    private final IFigure contents;

    public LineBorderedEllipseContainer(IFigure contents) {
        this.contents = contents;
        this.add(this.contents);
    }

    public IFigure getContents() {
        return this.contents;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = this.contents.getPreferredSize(wHint, hHint);
        double a = 0.5 * (double)size.width * Math.sqrt(2.0);
        double b = 0.5 * (double)size.height * Math.sqrt(2.0);
        int width = 2 * (int)Math.round(a);
        int height = 2 * (int)Math.round(b);
        return new Dimension(width + this.getBorderWidth() * 2, height + this.getBorderWidth() * 2);
    }

    protected void layout() {
        Rectangle bounds = this.getBounds().getCopy();
        bounds.x += this.getBorderWidth();
        bounds.y += this.getBorderWidth();
        bounds.width -= this.getBorderWidth() * 2;
        bounds.height -= this.getBorderWidth() * 2;
        double a = (double)bounds.width * 0.5;
        double b = (double)bounds.height * 0.5;
        int x = (int)Math.round(Math.sqrt(0.5 * a * a));
        int y = (int)Math.round(b * (double)x / a);
        int new_x = bounds.x + (int)Math.round(a - (double)x);
        int new_y = bounds.y + (int)Math.round(b - (double)y);
        int new_width = bounds.width - 2 * (int)Math.round(a - (double)x);
        int new_height = bounds.height - 2 * (int)Math.round(b - (double)y);
        this.contents.setBounds(new Rectangle(new_x, new_y, new_width, new_height));
    }
}

