/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.fujaba.commons.figures.LineBorderedFigure;
import org.fujaba.commons.figures.RoundedRectangleBorder;

public class LineBorderedRoundedRectangleFigure
extends LineBorderedFigure {
    public static final int ARC_RELATIVE = -1;
    private int arcX = -1;
    private int arcY = -1;
    private float relativeArcX = 0.2f;
    private float relativeArcY = 0.2f;
    private boolean symmetrical = true;

    public LineBorderedRoundedRectangleFigure() {
        this.setBorder(new RoundedRectangleBorder());
        this.setOpaque(true);
        this.setAntialias(true);
    }

    public LineBorderedRoundedRectangleFigure(int arcX, int arcY) {
        this();
        this.setArcX(arcX);
        this.setArcY(arcY);
    }

    public LineBorderedRoundedRectangleFigure(float relativeArcX, float relativeArcY) {
        this();
        this.setRelativeArcX(relativeArcX);
        this.setRelativeArcY(relativeArcY);
    }

    @Override
    public RoundedRectangleBorder getBorder() {
        return (RoundedRectangleBorder)super.getBorder();
    }

    @Override
    public void setBorder(Border border) {
        if (!(border instanceof RoundedRectangleBorder)) {
            throw new IllegalArgumentException("LineBorderedRoundedRectangleFigure expects a RoundedRectangleBorder as its border.");
        }
        super.setBorder(border);
    }

    public void setRelativeArc(float relativeArc) {
        this.setRelativeArcX(relativeArc);
        this.setRelativeArcY(relativeArc);
    }

    public float getRelativeArcX() {
        return this.relativeArcX;
    }

    public void setRelativeArcX(float relativeArcX) {
        this.relativeArcX = relativeArcX;
        this.arcX = -1;
        this.getBorder().setRelativeArcX(relativeArcX);
    }

    public float getRelativeArcY() {
        return this.relativeArcY;
    }

    public void setRelativeArcY(float relativeArcY) {
        this.relativeArcY = relativeArcY;
        this.arcY = -1;
        this.getBorder().setRelativeArcY(relativeArcY);
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        this.getBorder().setSymmetrical(symmetrical);
    }

    public void setArc(int arc) {
        this.setArcX(arc);
        this.setArcY(arc);
    }

    public int getArcX() {
        return this.arcX;
    }

    public void setArcX(int arcX) {
        this.arcX = arcX;
        this.symmetrical = false;
        this.getBorder().setArcX(arcX);
    }

    public int getArcY() {
        return this.arcY;
    }

    public void setArcY(int arcY) {
        this.arcY = arcY;
        this.symmetrical = false;
        this.getBorder().setArcY(arcY);
    }

    public void paintFigure(Graphics graphics) {
        int drawArcY;
        int drawArcX = this.getArcX();
        if (drawArcX == -1) {
            drawArcX = Math.round(this.getRelativeArcX() * (float)this.getBounds().width);
        }
        if ((drawArcY = this.getArcY()) == -1) {
            drawArcY = Math.round(this.getRelativeArcY() * (float)this.getBounds().width);
        }
        if (this.isSymmetrical()) {
            drawArcY = drawArcX = Math.min(drawArcX, drawArcY);
        }
        graphics.pushState();
        try {
            if (this.isOpaque() && this.getBackgroundColor() != null) {
                graphics.setBackgroundColor(this.getBackgroundColor());
                graphics.fillRoundRectangle(this.getBounds(), drawArcX, drawArcY);
            }
        }
        finally {
            graphics.popState();
        }
    }
}

