/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class LineFigure
extends Figure {
    private int lineStyle;
    private int orientation;
    private int width;
    private Color color = ColorConstants.black;

    public LineFigure() {
        this(1, 1, 256);
    }

    public LineFigure(int width, int style, int orientation) {
        this.setOpaque(true);
        this.width = width;
        this.lineStyle = style;
        this.orientation = orientation;
    }

    public LineFigure(Color color, int width, int style, int orientation) {
        this.setOpaque(true);
        this.width = width;
        this.lineStyle = style;
        this.orientation = orientation;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.pushState();
            try {
                graphics.setLineStyle(this.lineStyle);
                graphics.setLineWidth(this.width);
                graphics.setForegroundColor(this.color);
                Rectangle bounds = this.getBounds();
                if (this.orientation == 256) {
                    int y = bounds.y + bounds.height / 2;
                    graphics.drawLine(bounds.x, y, bounds.x + bounds.width, y);
                } else {
                    int x = bounds.x + bounds.width / 2;
                    graphics.drawLine(x, bounds.y, x, bounds.y + bounds.height);
                }
            }
            finally {
                graphics.popState();
            }
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.orientation == 256) {
            return new Dimension(wHint, this.width);
        }
        return new Dimension(this.width, hHint);
    }
}

