/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.fujaba.commons.figures.FigureWithAntialiasingSupport;

public class NodeFigure
extends FigureWithAntialiasingSupport {
    protected HashMap<String, ConnectionAnchor> connectionAnchors = new HashMap(7);
    protected Vector<ConnectionAnchor> inputConnectionAnchors = new Vector(2, 2);
    protected Vector<ConnectionAnchor> outputConnectionAnchors = new Vector(2, 2);

    public ConnectionAnchor connectionAnchorAt(Point p) {
        long d;
        Point p2;
        ConnectionAnchor c;
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<ConnectionAnchor> e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = e.nextElement();
            p2 = c.getLocation(null);
            d = (long)Math.pow(p.getDistance(p2), 2.0);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = e.nextElement();
            p2 = c.getLocation(null);
            d = (long)Math.pow(p.getDistance(p2), 2.0);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        return this.connectionAnchors.get(terminal);
    }

    public String getConnectionAnchorName(ConnectionAnchor connectionAnchor) {
        for (String key : this.connectionAnchors.keySet()) {
            ConnectionAnchor anchor = this.connectionAnchors.get(key);
            if (anchor == null || !anchor.equals(connectionAnchor)) continue;
            return key;
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point point) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<ConnectionAnchor> e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = e.nextElement();
            Point p2 = c.getLocation(null);
            long d = (long)Math.pow(point.getDistance(p2), 2.0);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector<ConnectionAnchor> getSourceConnectionAnchors() {
        return this.outputConnectionAnchors;
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point point) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<ConnectionAnchor> e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = e.nextElement();
            Point p2 = c.getLocation(null);
            long d = (long)Math.pow(point.getDistance(p2), 2.0);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector<ConnectionAnchor> getTargetConnectionAnchors() {
        return this.inputConnectionAnchors;
    }
}

