/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.fujaba.commons.figures.AbstractLineBorder;

public class RectangleBorder
extends AbstractLineBorder {
    public RectangleBorder() {
    }

    public RectangleBorder(int width) {
        this(null, width);
    }

    public RectangleBorder(Color color) {
        this(color, 1);
    }

    public RectangleBorder(Color color, int width) {
        this.setColor(color);
        this.setWidth(width);
    }

    public RectangleBorder(Color color, int width, int lineStyle) {
        this.setColor(color);
        this.setWidth(width);
        this.setLineStyle(lineStyle);
    }

    public Insets getInsets(IFigure figure) {
        return new Insets(this.getWidth());
    }

    @Override
    public void paintBorder(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(RectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --RectangleBorder.tempRect.width;
            --RectangleBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.drawRectangle(tempRect);
    }
}

