/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fujaba.commons.Commons4EclipseFonts;
import org.fujaba.commons.figures.LabelFigure;
import org.fujaba.commons.figures.LineBorderedRectangleWithCompartmentsFigure;
import org.fujaba.commons.figures.RectangleBorder;
import org.fujaba.commons.figures.ShadowDecoratorFigure;
import org.fujaba.commons.figures.UMLStereotypeFigure;

public class UMLObjectFigure
extends LineBorderedRectangleWithCompartmentsFigure {
    public static final String COMPARTMENT_STEREOTYPES = "stereotypes";
    public static final String COMPARTMENT_NAME = "name";
    public static final String COMPARTMENT_ATTR_EXPR = "attributes";
    private LabelFigure myLabel;
    private LabelFigure create_destroy_label;
    private boolean isNegative = false;
    private ShadowDecoratorFigure shadowDecorator;

    public UMLObjectFigure(String name) {
        this.setBorder(new RectangleBorder(ColorConstants.black, 1));
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.black);
        this.addCompartment(COMPARTMENT_STEREOTYPES, 0, 0);
        this.addCompartment(COMPARTMENT_NAME, 1, 1);
        this.addCompartment(COMPARTMENT_ATTR_EXPR, 1, 1);
        this.myLabel = new LabelFigure("", Commons4EclipseFonts.getFont("org.fujaba.commons.FONT_BOLD"));
        this.myLabel.setUnderlined(true);
        MarginBorder border = new MarginBorder(2, 5, 2, 5);
        this.myLabel.setBorder((Border)border);
        this.addFigureToCompartment(COMPARTMENT_NAME, (IFigure)this.myLabel);
        this.create_destroy_label = new LabelFigure("");
        this.setOpaque(true);
    }

    public void addToAttributes(LabelFigure attr) {
        attr.setLabelAlignment(1);
        this.addFigureToCompartment(COMPARTMENT_ATTR_EXPR, (IFigure)attr);
    }

    public void removeFromAttributes(LabelFigure attr) {
        this.removeFigureFromCompartment(COMPARTMENT_ATTR_EXPR, (IFigure)attr);
    }

    public void addToStereotypes(UMLStereotypeFigure stereotype) {
        this.addFigureToCompartment(COMPARTMENT_STEREOTYPES, (IFigure)stereotype);
    }

    public void removeFromStereotypes(UMLStereotypeFigure stereotype) {
        this.removeFigureFromCompartment(COMPARTMENT_STEREOTYPES, (IFigure)stereotype);
    }

    public String getName() {
        return this.myLabel.getText();
    }

    public void setName(String name) {
        this.myLabel.setText(name);
    }

    public LabelFigure getLabel() {
        return this.myLabel;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isNegative) {
            Rectangle bounds = this.getBounds();
            graphics.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y);
            graphics.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
        }
    }

    public void setDashedLine(boolean dashedLine) {
        if (dashedLine) {
            this.setBorderLineStyle(2);
        } else {
            this.setBorderLineStyle(1);
        }
    }

    public void setIsNegative(boolean b) {
        this.isNegative = b;
    }

    public void setShadowed(boolean shadowed) {
        if (shadowed) {
            this.shadowDecorator = new ShadowDecoratorFigure((IFigure)this, 5, -5);
            this.shadowDecorator.setOpaque(true);
        } else if (this.shadowDecorator != null) {
            this.shadowDecorator.removeDecorator();
            this.shadowDecorator = null;
        }
    }

    public void setIsSet(boolean b) {
        this.setShadowed(b);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension nameSize = this.getCompartment(COMPARTMENT_NAME).getPreferredSize(wHint, hHint);
        Dimension stereotypeSize = this.getCompartment(COMPARTMENT_STEREOTYPES).getPreferredSize(wHint, hHint);
        Dimension size = new Dimension(nameSize);
        size.height += stereotypeSize.height;
        size.width = Math.max(nameSize.width, stereotypeSize.width);
        return new Dimension(size.width + 10, size.height + 2);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        return super.getPreferredSize(wHint, hHint).getCopy().expand(10, 2);
    }

    public LabelFigure getNameLabel() {
        return this.myLabel;
    }

    public LabelFigure getCreateOrDeleteLabel() {
        return this.create_destroy_label;
    }

    public void setCreateOrDeleteLableVisible(boolean visible) {
        if (visible) {
            this.addFigureToCompartment(COMPARTMENT_NAME, (IFigure)this.create_destroy_label, 0);
        } else {
            this.removeFigureFromCompartment(COMPARTMENT_NAME, (IFigure)this.create_destroy_label);
        }
    }
}

