/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.figures.utils;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;

public class ConnectionDecorationFactory {
    public static final int NO_DECORATION = 0;
    public static final int OPEN_ARROW = 1;
    public static final int CLOSED_ARROW = 2;
    public static final int RHOMB = 3;
    public static final int SMALL_CLOSED_ARROW = 4;

    private static PolygonDecoration createClosedArrowDecoration() {
        PointList decorationPointList = new PointList();
        Point aPointRef = new Point(0, 0);
        decorationPointList.addPoint(aPointRef);
        Point aPoint = new Point(-2, 2);
        decorationPointList.addPoint(aPoint.getTranslated(aPointRef));
        aPoint = new Point(-2, -2);
        decorationPointList.addPoint(aPoint.getTranslated(aPointRef));
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(decorationPointList);
        decoration.setScale(5.0, 2.0);
        return decoration;
    }

    private static PolygonDecoration createOpenArrowDecoration() {
        PointList decorationPointList = new PointList();
        Point aPointRef = new Point(0, 0);
        decorationPointList.addPoint(aPointRef);
        Point aPoint = new Point(-2, 2);
        decorationPointList.addPoint(aPoint.getTranslated(aPointRef));
        decorationPointList.addPoint(aPointRef);
        aPoint = new Point(-2, -2);
        decorationPointList.addPoint(aPoint.getTranslated(aPointRef));
        PolygonDecoration decoration = new PolygonDecoration();
        decoration.setTemplate(decorationPointList);
        decoration.setScale(5.0, 2.0);
        return decoration;
    }

    private static PolygonDecoration createRhombDecoration() {
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setScale(4.0, 2.0);
        return decoration;
    }

    private static PolygonDecoration createSmallClosedArrowDecoration() {
        PolygonDecoration arrow = new PolygonDecoration();
        PointList arrowPointList = new PointList();
        arrowPointList.addPoint(1, 1);
        arrowPointList.addPoint(1, -1);
        arrowPointList.addPoint(-1, 0);
        arrow.setTemplate(arrowPointList);
        arrow.setScale(4.0, 3.0);
        return arrow;
    }

    public static PolygonDecoration createDecoration(int type) {
        return ConnectionDecorationFactory.createDecoration(type, ColorConstants.black, ColorConstants.black);
    }

    public static PolygonDecoration createDecoration(int type, Color backgroundColor, Color foregroundColor) {
        PolygonDecoration decoration;
        switch (type) {
            case 1: {
                decoration = ConnectionDecorationFactory.createOpenArrowDecoration();
                break;
            }
            case 2: {
                decoration = ConnectionDecorationFactory.createClosedArrowDecoration();
                break;
            }
            case 4: {
                decoration = ConnectionDecorationFactory.createSmallClosedArrowDecoration();
                break;
            }
            case 3: {
                decoration = ConnectionDecorationFactory.createRhombDecoration();
                break;
            }
            default: {
                decoration = null;
            }
        }
        if (decoration != null) {
            decoration.setBackgroundColor(backgroundColor);
            decoration.setForegroundColor(foregroundColor);
        }
        return decoration;
    }
}

