/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fujaba.commons.edit.commands.SetConstraintCommand;
import org.fujaba.commons.edit.parts.AbstractDiagramEditPart;
import org.fujaba.commons.edit.parts.AbstractNodeEditPart;

public class ResizeHandler
extends AbstractHandler {
    private static final String TO_MINIMUM = "org.fujaba.commons.editor.resize.minimum";
    private static final String USE_COMMAND_STACK = "org.fujaba.commons.editor.resize.commandstack";

    private static List<?> getSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        return ((IStructuredSelection)selection).toList();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean toMinimum = Boolean.valueOf(event.getParameter(TO_MINIMUM));
        boolean useCommandStack = Boolean.valueOf(event.getParameter(USE_COMMAND_STACK));
        CompoundCommand cc = new CompoundCommand();
        for (Object selected : ResizeHandler.getSelection(event)) {
            if (!(selected instanceof AbstractNodeEditPart)) continue;
            if (selected instanceof AbstractDiagramEditPart) {
                cc.add(ResizeHandler.getCommands((AbstractDiagramEditPart)selected, toMinimum));
            }
            cc.add(ResizeHandler.getCommand((AbstractNodeEditPart)selected, toMinimum));
        }
        if (useCommandStack) {
            CommandStack stack = (CommandStack)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(CommandStack.class);
            if (stack != null) {
                stack.execute(cc.unwrap());
            }
        } else {
            cc.unwrap().execute();
        }
        return null;
    }

    private static Command getCommand(AbstractNodeEditPart part, boolean minimum) {
        Dimension dim = minimum ? part.getMinimumSize() : part.getPreferredSize();
        int x = part.getModel().getX();
        int y = part.getModel().getY();
        Rectangle constraint = new Rectangle(x, y, dim.width, dim.height);
        return new SetConstraintCommand(part, constraint);
    }

    public static Command getCommands(AbstractDiagramEditPart selected, boolean minimum) {
        CompoundCommand cc = new CompoundCommand();
        for (Object child : selected.getChildren()) {
            if (!(child instanceof AbstractNodeEditPart)) continue;
            if (child instanceof AbstractDiagramEditPart) {
                cc.add(ResizeHandler.getCommands((AbstractDiagramEditPart)child, minimum));
            }
            cc.add(ResizeHandler.getCommand((AbstractNodeEditPart)child, minimum));
        }
        return cc;
    }
}

