/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import java.util.regex.Pattern;
import org.fujaba.commons.properties.section.AbstractTextSection;

public abstract class AbstractDoubleSection
extends AbstractTextSection {
    public static final String EXP_NUMERIC_PATTERN = "^[-\\d][\\d]*\\.?[\\d]*((e|E)?-?[\\d]*)";
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("^[-\\d][\\d]*\\.?[\\d]*((e|E)?-?[\\d]*)");

    @Override
    protected String getFeatureAsString() {
        return this.getFeatureDouble().toString();
    }

    protected abstract Double getFeatureDouble();

    @Override
    protected Object getNewFeatureValue(String newText) {
        if (newText == null || newText.isEmpty()) {
            return null;
        }
        return new Double(Double.parseDouble(newText));
    }

    @Override
    protected Object getOldFeatureValue() {
        return this.getFeatureDouble();
    }

    @Override
    protected boolean isTextValid() {
        return DOUBLE_PATTERN.matcher(this.getText().getText()).matches();
    }
}

