/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.fujaba.commons.properties.section.AbstractSection;

public abstract class AbstractEnumRadioSelectionSection
extends AbstractSection {
    private Map<Button, Object> buttons = new HashMap<Button, Object>();
    private CLabel label;
    private Composite group;

    @Override
    protected void createWidgets(Composite composite) {
        List<? extends Object> literals = this.getLiterals();
        this.group = this.getWidgetFactory().createComposite(composite);
        GridLayoutFactory.fillDefaults().numColumns(literals.size()).applyTo(this.group);
        int style = 16400;
        for (Object object : literals) {
            Button button = this.getWidgetFactory().createButton(this.group, this.getLiteralText(object), style);
            GridDataFactory.fillDefaults().applyTo((Control)button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractEnumRadioSelectionSection.this.handleSelection(e);
                }
            });
            this.buttons.put(button, object);
        }
        this.label = this.getWidgetFactory().createCLabel(composite, this.getLabelText(), 131072);
    }

    protected Collection<Button> getButtons() {
        return this.buttons.keySet();
    }

    protected abstract List<? extends Object> getLiterals();

    protected abstract String getLiteralText(Object var1);

    protected Object getObject(Button button) {
        return this.buttons.get(button);
    }

    protected abstract Object getValue();

    protected void handleSelection(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            this.createCommand(this.getValue(), this.getObject((Button)e.getSource()));
        }
    }

    public void refresh() {
        Object current = this.getValue();
        for (Button button : this.buttons.keySet()) {
            if (this.buttons.get(button).equals(current)) {
                button.setSelection(true);
                continue;
            }
            button.setSelection(false);
        }
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.group.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.group, -5);
        data.top = new FormAttachment((Control)this.group, 0, 128);
        data.bottom = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
    }
}

