/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fujaba.commons.properties.PropertiesAdapterImpl;
import org.fujaba.commons.properties.util.AdapterUtil;
import org.fujaba.commons.properties.util.MessageManager;

public abstract class AbstractSection
extends AbstractPropertySection {
    private EObject element;
    private List<EObject> elements;
    private IStatusLineManager statusLineManager;
    private MessageManager messageManager;
    private Composite section;
    private Adapter modelListener = new PropertiesAdapterImpl(){

        @Override
        protected void safeNotifyChanged(Notification msg) {
            AbstractSection.this.handleModelChanged(msg);
        }
    };

    public static boolean isBoolean(EAttribute attribute) {
        if (attribute != null) {
            return EcorePackage.eINSTANCE.getEBoolean().equals(attribute.getEAttributeType());
        }
        return false;
    }

    public static boolean isDouble(EAttribute attribute) {
        if (attribute != null) {
            return EcorePackage.eINSTANCE.getEDouble().equals(attribute.getEAttributeType());
        }
        return false;
    }

    public static boolean isEnum(EAttribute attribute) {
        if (attribute != null) {
            return attribute.getEAttributeType() instanceof EEnum;
        }
        return false;
    }

    public static boolean isInteger(EAttribute attribute) {
        if (attribute != null) {
            return EcorePackage.eINSTANCE.getEInt().equals(attribute.getEAttributeType());
        }
        return false;
    }

    public void aboutToBeHidden() {
        this.removeListener();
    }

    public void aboutToBeShown() {
        this.addListener();
    }

    protected void addListener() {
        if (this.getElement() != null && !this.getElement().eAdapters().contains((Object)this.modelListener)) {
            this.getElement().eAdapters().add((Object)this.modelListener);
        }
    }

    protected void clearDecorators() {
        this.messageManager.removeAllMessages();
    }

    protected void createCommand(Object oldValue, Object newValue) {
        boolean equals;
        boolean bl = equals = oldValue == null ? false : oldValue.equals(newValue);
        if (!equals) {
            EditingDomain editingDomain = this.getEditingDomain();
            Object value = newValue;
            if (this.getElements().size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.getElement(), (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.getElements()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage page) {
        super.createControls(parent, page);
        this.section = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createWidgets(this.section);
        this.setSectionData(this.section);
        this.hookListeners();
        this.messageManager = new MessageManager();
        this.statusLineManager = page.getSite().getActionBars().getStatusLineManager();
    }

    protected abstract void createWidgets(Composite var1);

    protected EditingDomain getEditingDomain() {
        IPage page;
        IWorkbenchPart part = this.getPart();
        if (part.getAdapter(EditingDomain.class) != null) {
            return (EditingDomain)this.getPart().getAdapter(EditingDomain.class);
        }
        if (part instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)part).getEditingDomain();
        }
        if (part.getAdapter(IEditingDomainProvider.class) != null) {
            return ((IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)).getEditingDomain();
        }
        if (part instanceof PageBookView && (page = ((PageBookView)part).getCurrentPage()) instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)page).getEditingDomain();
        }
        throw new IllegalArgumentException();
    }

    protected EObject getElement() {
        return this.element;
    }

    protected List<EObject> getElements() {
        return this.elements;
    }

    protected abstract EStructuralFeature getFeature();

    protected abstract String getLabelText();

    protected int getStandardLabelWidth(Composite parent, String label) {
        return this.getStandardLabelWidth(parent, new String[]{label});
    }

    protected int getStandardLabelWidth(Composite parent, String[] labels) {
        int standardLabelWidth = 100;
        GC gc = new GC((Drawable)parent);
        int indent = gc.textExtent((String)"XXX").x;
        int i = 0;
        while (i < labels.length) {
            int width = gc.textExtent((String)labels[i]).x;
            if (width + indent > standardLabelWidth) {
                standardLabelWidth = width + indent;
            }
            ++i;
        }
        gc.dispose();
        return standardLabelWidth;
    }

    protected void handleModelChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (notifier.equals(this.getElement()) && this.getFeature() != null && msg.getFeatureID(this.getElement().getClass()) == this.getFeature().getFeatureID()) {
            this.refresh();
        }
    }

    protected void hookListeners() {
    }

    protected boolean isReadOnly() {
        Resource resource = this.getElement().eResource();
        EditingDomain domain = this.getEditingDomain();
        return domain != null && resource != null && domain.isReadOnly(resource);
    }

    protected void removeListener() {
        if (this.getElement() != null && this.getElement().eAdapters().contains((Object)this.modelListener)) {
            this.getElement().eAdapters().remove((Object)this.modelListener);
        }
    }

    private void setDecorator(Control control, String message, int type) {
        this.messageManager.addMessage("", message, null, type, control);
    }

    protected void setErrorDecorator(Control control, String message) {
        this.setDecorator(control, message, 3);
    }

    protected void setErrorMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setErrorMessage(message);
        }
    }

    protected void setInfoDecorator(Control control, String message) {
        this.setDecorator(control, message, 1);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object selected = ((IStructuredSelection)selection).getFirstElement();
        this.removeListener();
        this.element = AdapterUtil.adaptObject(selected);
        this.elements = new ArrayList<EObject>();
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            EObject realElement = AdapterUtil.adaptObject(element);
            if (realElement != null) {
                this.elements.add(realElement);
            }
            ++n2;
        }
        this.addListener();
    }

    protected void setMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    protected void setSectionData(Composite parent) {
    }

    protected void setWarningDecorator(Control control, String message) {
        this.setDecorator(control, message, 2);
    }

    protected Adapter getModelListener() {
        return this.modelListener;
    }
}

