/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.fujaba.commons.properties.section.AbstractSection;
import org.fujaba.commons.properties.util.ColorRegistry;
import org.fujaba.commons.properties.util.TextChangeListener;

public abstract class AbstractTextSection
extends AbstractSection {
    private Text text;
    private CLabel label;
    private TextChangeListener listener;

    @Override
    protected void createWidgets(Composite composite) {
        this.text = this.getWidgetFactory().createText(composite, "", this.getStyle());
        if (this.getFeature() != null) {
            boolean isChangeable = this.getFeature().isChangeable();
            this.text.setEditable(isChangeable);
            this.text.setEnabled(isChangeable);
        }
        this.label = this.getWidgetFactory().createCLabel(composite, this.getLabelText(), 131072);
        String tooltip = this.getTooltip();
        if (tooltip != null && !tooltip.isEmpty()) {
            this.label.setToolTipText(tooltip);
        } else {
            this.label.setToolTipText(null);
        }
    }

    protected void focusIn() {
    }

    protected void focusOut() {
    }

    protected abstract String getErrorMessage();

    protected abstract String getFeatureAsString();

    protected abstract Object getNewFeatureValue(String var1);

    protected abstract Object getOldFeatureValue();

    protected int getStyle() {
        return 4;
    }

    protected Text getText() {
        return this.text;
    }

    protected abstract String getTooltip();

    protected void handleTextModified() {
        if (this.isTextValid()) {
            this.createCommand(this.getOldFeatureValue(), this.getNewFeatureValue(this.getText().getText()));
        } else {
            this.refresh();
        }
    }

    @Override
    protected void hookListeners() {
        this.label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractTextSection.this.text.setFocus();
                int end = AbstractTextSection.this.text.getText().length();
                AbstractTextSection.this.text.setSelection(0, end);
            }
        });
        this.listener = new TextChangeListener(){

            @Override
            public void focusIn(Control control) {
                AbstractTextSection.this.focusIn();
            }

            @Override
            public void focusOut(Control control) {
                AbstractTextSection.this.focusOut();
            }

            @Override
            public void textChanged(Control control) {
                AbstractTextSection.this.handleTextModified();
            }
        };
        this.listener.startListeningTo((Control)this.text);
        if ((this.getStyle() & 2) == 0) {
            this.listener.startListeningForEnter((Control)this.text);
        }
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                AbstractTextSection.this.verifyField(e);
            }
        });
    }

    protected boolean isTextValid() {
        return true;
    }

    public void refresh() {
        this.getText().setEnabled(!this.isReadOnly());
        this.getText().setText(this.getFeatureAsString());
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -5);
        data.top = new FormAttachment((Control)this.text, 0, 128);
        this.label.setLayoutData((Object)data);
    }

    protected void verifyField(Event e) {
        String value = this.getText().getText();
        if (value == null || value.isEmpty() || this.isTextValid()) {
            this.setErrorMessage(null);
            this.getText().setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage(this.getErrorMessage());
            this.getText().setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }
}

