/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.section;

import com.google.inject.Injector;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.fujaba.commons.editor.xtext.EmbeddedXtextEditor;
import org.fujaba.commons.properties.section.AbstractSection;

public abstract class AbstractXtextSection
extends AbstractSection {
    private CLabel label;
    private EmbeddedXtextEditor editor;

    protected abstract Injector getInjector();

    protected int getStyle() {
        return 2818;
    }

    @Override
    protected void createWidgets(Composite composite) {
        Injector injector = this.getInjector();
        this.editor = new EmbeddedXtextEditor(composite, injector, this.getStyle());
        this.editor.getDocument().addModelListener(new IXtextModelListener(){

            public void modelChanged(XtextResource resource) {
            }
        });
        this.editor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.label = this.getWidgetFactory().createCLabel(composite, this.getLabelText(), 131072);
        String tooltip = this.getTooltip();
        if (tooltip != null && !tooltip.isEmpty()) {
            this.label.setToolTipText(tooltip);
        } else {
            this.label.setToolTipText(null);
        }
    }

    protected abstract String getFeatureAsString();

    protected abstract Object getNewFeatureValue(String var1);

    protected abstract Object getOldFeatureValue();

    protected String getTooltip() {
        return null;
    }

    protected void handleTextModified() {
        if (this.isTextValid()) {
            this.createCommand(this.getOldFeatureValue(), this.editor.getDocument().get());
        } else {
            this.refresh();
        }
    }

    @Override
    protected void hookListeners() {
        this.editor.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                AbstractXtextSection.this.handleTextModified();
            }
        });
    }

    protected boolean isTextValid() {
        return true;
    }

    public void refresh() {
        if (this.editor != null) {
            this.editor.getViewer().setEditable(!this.isReadOnly());
            this.editor.getDocument().set(this.getFeatureAsString());
        }
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.editor.getViewer().getControl().setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(this.editor.getViewer().getControl(), -5);
        data.top = new FormAttachment(this.editor.getViewer().getControl(), 0, 128);
        this.label.setLayoutData((Object)data);
    }

    protected String getText() {
        return this.editor.getDocument().get();
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }
}

