/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class ColorRegistry {
    public static Color COLOR_ERROR = ColorRegistry.getInstance().get("255,128,128");
    public static Color COLOR_WARNING = ColorRegistry.getInstance().get("249,240,163");
    public static Color COLOR_INFO = ColorRegistry.getInstance().get("128,128,255");
    public static Color COLOR_BLACK = ColorRegistry.getInstance().get("0,0,0");
    public static Color COLOR_WHITE = ColorRegistry.getInstance().get("255,255,255");
    public static Color COLOR_RED = ColorRegistry.getInstance().get("255,0,0");
    public static Color COLOR_GREEN = ColorRegistry.getInstance().get("0,255,0");
    public static Color COLOR_BLUE = ColorRegistry.getInstance().get("0,0,255");
    public static Color COLOR_SOFT_GREY = ColorRegistry.getInstance().get("219,211,203");
    private static ColorRegistry instance;
    protected Display display;
    private Map<String, Color> colors = new HashMap<String, Color>(7);
    protected Runnable cleanUpRunnable = new Runnable(){

        @Override
        public void run() {
            ColorRegistry.this.clear();
        }
    };

    public static ColorRegistry getInstance() {
        if (instance == null) {
            instance = new ColorRegistry();
        }
        return instance;
    }

    private ColorRegistry() {
        this(PlatformUI.getWorkbench().getDisplay());
    }

    private ColorRegistry(Display display) {
        Assert.isNotNull((Object)display);
        this.display = display;
        this.hookDisplayDispose();
    }

    private void hookDisplayDispose() {
        this.display.disposeExec(this.cleanUpRunnable);
    }

    private void clear() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        this.colors.clear();
    }

    public Color get(String symbolicName) {
        Assert.isNotNull((Object)symbolicName);
        if (symbolicName.isEmpty()) {
            return new Color((Device)this.display, new RGB(0, 0, 0));
        }
        return this.get(StringConverter.asRGB((String)symbolicName));
    }

    public Color get(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        String symbolicName = StringConverter.asString((RGB)rgb);
        Color result = this.colors.get(symbolicName);
        if (result != null) {
            return result;
        }
        Color color = new Color((Device)this.display, rgb);
        this.colors.put(symbolicName, color);
        return color;
    }
}

