/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.util;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.fujaba.commons.FujabaCommonsPlugin;

public class SingleReferenceSelectionDialog
extends Dialog {
    private String title;
    private TableViewer viewer;
    private CLabel infoboxHeader;
    private Text infoboxText;
    private EReference selected;
    private Collection<EReference> input;

    public SingleReferenceSelectionDialog() {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Label filtered = new Label(main, 16384);
        filtered.setText("&Available references:");
        this.viewer = new TableViewer(main, 2560);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PSLinkTypeLabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTable());
        this.infoboxHeader = new CLabel(main, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxHeader);
        this.infoboxText = new Text(main, 16458);
        this.infoboxText.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxText);
        this.hookListeners();
        this.viewer.setInput(this.input);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.selected));
        return main;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = FujabaCommonsPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = root.addNewSection(((Object)((Object)this)).getClass().getName());
            settings.put("DIALOG_X_ORIGIN", 50);
            settings.put("DIALOG_Y_ORIGIN", 50);
            settings.put("DIALOG_WIDTH", 430);
            settings.put("DIALOG_HEIGHT", 500);
        }
        return settings;
    }

    public EReference getSelected() {
        return this.selected;
    }

    protected void handleSelection(StructuredSelection selection) {
        this.selected = (EReference)selection.getFirstElement();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String header = ((PSLinkTypeLabelProvider)SingleReferenceSelectionDialog.this.viewer.getLabelProvider()).getQualifiedText(SingleReferenceSelectionDialog.this.selected);
                Image image = ((PSLinkTypeLabelProvider)SingleReferenceSelectionDialog.this.viewer.getLabelProvider()).getImage(SingleReferenceSelectionDialog.this.selected);
                SingleReferenceSelectionDialog.this.infoboxHeader.setImage(image);
                SingleReferenceSelectionDialog.this.infoboxHeader.setText(header);
                String info = EcoreUtil.getDocumentation((EModelElement)SingleReferenceSelectionDialog.this.selected);
                if (info == null || info.trim().isEmpty()) {
                    info = "No further documentation available.";
                }
                SingleReferenceSelectionDialog.this.infoboxText.setText(info);
                SingleReferenceSelectionDialog.this.infoboxText.getParent().layout();
            }
        });
        Button okay = this.getButton(0);
        if (okay != null) {
            okay.setEnabled(this.selected != null);
        }
    }

    private void hookListeners() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleReferenceSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleReferenceSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
                if (SingleReferenceSelectionDialog.this.selected != null) {
                    SingleReferenceSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInput(Collection<EReference> input, EReference current) {
        this.selected = current;
        this.input = input;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private class PSLinkTypeLabelProvider
    extends LabelProvider {
        private AdapterFactoryLabelProvider imageProvider = new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());

        public Image getImage(Object element) {
            return this.imageProvider.getImage(element);
        }

        public String getQualifiedText(Object element) {
            EReference reference = (EReference)element;
            StringBuilder text = new StringBuilder();
            text.append(reference.getEContainingClass().getName());
            text.append(".");
            text.append(reference.getName());
            return text.toString();
        }

        public String getText(Object element) {
            EReference reference = (EReference)element;
            StringBuilder text = new StringBuilder();
            text.append(reference.getName());
            text.append(": ");
            text.append(reference.getEReferenceType().getName());
            return text.toString();
        }
    }
}

