/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.properties.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.fujaba.commons.FujabaCommonsPlugin;
import org.fujaba.commons.properties.TreeNodeLabelProvider;
import org.fujaba.commons.properties.util.CamelCaseFilter;

public class SingleTypeSelectionDialog
extends Dialog {
    private static final CamelCaseFilter FILTER = new CamelCaseFilter();
    private String title;
    private Text filterText;
    private TreeViewer viewer;
    private CLabel infoboxHeader;
    private Text infoboxText;
    private EClassifier selected;
    private TreeNode[] input;
    private TreeNode currentNode;

    private static void addChild(TreeNode node, TreeNode child) {
        TreeNode[] oldChildren = node.getChildren();
        if (oldChildren != null) {
            TreeNode[] newChildren = new TreeNode[oldChildren.length + 1];
            int i = 0;
            while (i < oldChildren.length) {
                if (oldChildren[i].equals((Object)child)) {
                    return;
                }
                newChildren[i] = oldChildren[i];
                ++i;
            }
            newChildren[oldChildren.length] = child;
            node.setChildren(newChildren);
        } else {
            node.setChildren(new TreeNode[]{child});
        }
    }

    public SingleTypeSelectionDialog() {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Label hint = new Label(main, 16384);
        hint.setText("&Enter type name prefix or pattern (*, ?, or camel case):");
        int style = 18564;
        this.filterText = new Text(main, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        Label filtered = new Label(main, 16384);
        filtered.setText("&Matching types:");
        this.viewer = new TreeViewer(main, 2560);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeNodeLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setAutoExpandLevel(2);
        this.viewer.addFilter((ViewerFilter)FILTER);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        this.infoboxHeader = new CLabel(main, 16384);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxHeader);
        this.infoboxText = new Text(main, 16458);
        this.infoboxText.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoboxText);
        this.hookListeners();
        FILTER.setQuery(null);
        this.viewer.setInput((Object)this.input);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.currentNode));
        return main;
    }

    private TreeNode createNode(EClassifier type, TreeNode parent, Collection<? extends EClassifier> types) {
        TreeNode node = new TreeNode((Object)type);
        if (this.selected.equals(type) && this.currentNode == null) {
            this.currentNode = node;
        }
        node.setParent(parent);
        SingleTypeSelectionDialog.addChild(parent, node);
        for (EClassifier eClassifier : types) {
            if (!(eClassifier instanceof EClass) || !((EClass)eClassifier).getESuperTypes().contains((Object)type)) continue;
            TreeNode child = this.createNode(eClassifier, node, types);
            SingleTypeSelectionDialog.addChild(node, child);
        }
        return node;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = FujabaCommonsPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(((Object)((Object)this)).getClass().getName());
        if (settings == null) {
            settings = root.addNewSection(((Object)((Object)this)).getClass().getName());
            settings.put("DIALOG_X_ORIGIN", 50);
            settings.put("DIALOG_Y_ORIGIN", 50);
            settings.put("DIALOG_WIDTH", 430);
            settings.put("DIALOG_HEIGHT", 500);
        }
        return settings;
    }

    public EClassifier getSelected() {
        return this.selected;
    }

    protected void handleSelection(StructuredSelection selection) {
        Button okay;
        final TreeNode node = (TreeNode)selection.getFirstElement();
        this.selected = null;
        if (node.getValue() instanceof EClass) {
            this.selected = (EClass)node.getValue();
        }
        if (node.getValue() instanceof ENamedElement) {
            final ENamedElement element = (ENamedElement)node.getValue();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String header = element.getName();
                    if (element instanceof EClass) {
                        header = ((EClass)element).getInstanceTypeName();
                    }
                    Image image = ((TreeNodeLabelProvider)SingleTypeSelectionDialog.this.viewer.getLabelProvider()).getImage(node);
                    SingleTypeSelectionDialog.this.infoboxHeader.setImage(image);
                    SingleTypeSelectionDialog.this.infoboxHeader.setText(header);
                    String info = EcoreUtil.getDocumentation((EModelElement)((EModelElement)node.getValue()));
                    if (info == null || info.trim().isEmpty()) {
                        info = "No further documentation available.";
                    }
                    SingleTypeSelectionDialog.this.infoboxText.setText(info);
                    SingleTypeSelectionDialog.this.infoboxText.getParent().layout();
                }
            });
        }
        if ((okay = this.getButton(0)) != null) {
            okay.setEnabled(this.selected != null);
        }
    }

    private void hookListeners() {
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FILTER.setQuery(SingleTypeSelectionDialog.this.filterText.getText());
                        if (SingleTypeSelectionDialog.this.viewer != null && SingleTypeSelectionDialog.this.viewer.getTree() != null && !SingleTypeSelectionDialog.this.viewer.getTree().isDisposed()) {
                            SingleTypeSelectionDialog.this.viewer.refresh();
                            SingleTypeSelectionDialog.this.viewer.expandAll();
                        }
                    }
                });
            }
        });
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleTypeSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof StructuredSelection) {
                    SingleTypeSelectionDialog.this.handleSelection((StructuredSelection)event.getSelection());
                }
                if (SingleTypeSelectionDialog.this.selected != null) {
                    SingleTypeSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    public void setInput(Collection<? extends EClassifier> input, EClassifier current) {
        this.selected = current;
        this.currentNode = null;
        ArrayList<EPackage> packages = new ArrayList<EPackage>();
        for (EClassifier eClassifier : input) {
            if (packages.contains(eClassifier.getEPackage())) continue;
            packages.add(eClassifier.getEPackage());
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (EPackage pack : packages) {
            TreeNode packNode = new TreeNode((Object)pack);
            for (EClassifier type : pack.getEClassifiers()) {
                if (!(type instanceof EClass)) continue;
                boolean add = true;
                for (EClass parent : ((EClass)type).getESuperTypes()) {
                    if (!parent.getEPackage().equals(pack)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.createNode(type, packNode, input);
            }
            arrayList.add(packNode);
        }
        this.input = arrayList.toArray(new TreeNode[arrayList.size()]);
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

