/*
 * Decompiled with CFR 0.152.
 */
package org.fujaba.commons.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fujaba.commons.utils.OrderedNode;

public class TopologicalOrder<T> {
    private boolean groupRelatedElementsFlag = true;
    private boolean isPreSorted = false;
    private Map<String, OrderedNode<T>> nodes = new ConcurrentHashMap<String, OrderedNode<T>>();

    public boolean getGroupRelatedElementsFlag() {
        return this.groupRelatedElementsFlag;
    }

    public void setGroupRelatedElementsFlag(boolean groupRelatedElementsFlag) {
        this.groupRelatedElementsFlag = groupRelatedElementsFlag;
    }

    private void flagRelatedElements() {
        if (!this.isPreSorted) {
            Iterator<OrderedNode<T>> it = this.iteratorOfNodes();
            while (it.hasNext()) {
                OrderedNode<T> current = it.next();
                if (current.sizeOfPrevious() == 0) {
                    current.setRoot(true);
                    continue;
                }
                current.setRoot(false);
            }
            this.isPreSorted = true;
        }
    }

    public int size() {
        return this.nodes.size();
    }

    public OrderedNode<T> head() {
        if (this.groupRelatedElementsFlag && !this.isPreSorted) {
            this.flagRelatedElements();
        }
        OrderedNode<T> head = null;
        Iterator<OrderedNode<T>> it = this.iteratorOfNodes();
        while (it.hasNext()) {
            OrderedNode<T> current = it.next();
            if (current.sizeOfPrevious() != 0) continue;
            if (!this.groupRelatedElementsFlag) {
                return current;
            }
            if (head == null) {
                head = current;
                continue;
            }
            if (head.isRoot() && !current.isRoot()) {
                head = current;
                continue;
            }
            if (head.isRoot() != current.isRoot() || head.sizeOfNext() <= current.sizeOfNext()) continue;
            head = current;
        }
        return head;
    }

    public OrderedNode<T> dequeue() {
        OrderedNode<T> head = this.head();
        if (head != null) {
            head.removeAllFromNext();
            this.nodes.remove(this.getKeyForNode(head));
        }
        return head;
    }

    public Map<String, OrderedNode<T>> getNodes() {
        return this.nodes;
    }

    public void add(OrderedNode<T> node) {
        this.nodes.put(this.getKeyForNode(node), node);
        this.isPreSorted = false;
    }

    public OrderedNode<T> get(String id) {
        if (this.nodes.containsKey(id)) {
            return this.nodes.get(id);
        }
        return null;
    }

    public void remove(String id) {
        this.nodes.remove(id);
        this.isPreSorted = false;
    }

    public String getKeyForNode(OrderedNode<T> value) {
        return value == null ? null : value.getId();
    }

    public Iterator<OrderedNode<T>> iteratorOfNodes() {
        return this.nodes.values().iterator();
    }
}

