/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ArrayFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Complex;
import org.jscience.mathematics.structure.VectorSpaceNormed;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class ComplexVector
extends Vector<Complex>
implements VectorSpaceNormed<Vector<Complex>, Complex> {
    protected static final XMLFormat<ComplexVector> XML = new XMLFormat<ComplexVector>(ComplexVector.class){

        public ComplexVector newInstance(Class<ComplexVector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            int dimension = xml.getAttribute("dimension", 0);
            ComplexVector V = (ComplexVector)FACTORY.array(dimension);
            V._dimension = dimension;
            return V;
        }

        public void read(XMLFormat.InputElement xml, ComplexVector V) throws XMLStreamException {
            int i = 0;
            int n = V._dimension;
            while (i < n) {
                ((ComplexVector)V)._reals[i++] = ((Complex)xml.getNext()).doubleValue();
            }
            if (xml.hasNext()) {
                throw new XMLStreamException("Too many elements");
            }
        }

        public void write(ComplexVector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("dimension", V._dimension);
            int i = 0;
            int n = V._dimension;
            while (i < n) {
                xml.add((Object)V.get(i++));
            }
        }
    };
    private static final ArrayFactory<ComplexVector> FACTORY = new ArrayFactory<ComplexVector>(){

        protected ComplexVector create(int capacity) {
            return new ComplexVector(capacity, null);
        }
    };
    private int _dimension;
    private final double[] _reals;
    private double[] _imags;
    private static final long serialVersionUID = 1L;

    private ComplexVector(int capacity) {
        this._reals = new double[capacity];
        this._imags = new double[capacity];
    }

    public static ComplexVector valueOf(Complex ... elements) {
        int n = elements.length;
        ComplexVector V = (ComplexVector)FACTORY.array(n);
        V._dimension = n;
        int i = 0;
        while (i < n) {
            Complex complex = elements[i];
            V._reals[i] = complex.getReal();
            V._imags[i] = complex.getImaginary();
            ++i;
        }
        return V;
    }

    public static ComplexVector valueOf(List<Complex> elements) {
        int n = elements.size();
        ComplexVector V = (ComplexVector)FACTORY.array(n);
        V._dimension = n;
        Iterator<Complex> iterator = elements.iterator();
        int i = 0;
        while (i < n) {
            Complex complex = iterator.next();
            V._reals[i] = complex.getReal();
            V._imags[i] = complex.getImaginary();
            ++i;
        }
        return V;
    }

    public static ComplexVector valueOf(Vector<Complex> that) {
        if (that instanceof ComplexVector) {
            return (ComplexVector)that;
        }
        int n = that.getDimension();
        ComplexVector V = (ComplexVector)FACTORY.array(n);
        V._dimension = n;
        int i = 0;
        while (i < n) {
            Complex complex = that.get(i);
            V._reals[i] = complex.getReal();
            V._imags[i] = complex.getImaginary();
            ++i;
        }
        return V;
    }

    public double getReal(int i) {
        if (i >= this._dimension) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._reals[i];
    }

    public double getImaginary(int i) {
        if (i >= this._dimension) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._imags[i];
    }

    @Override
    public Complex norm() {
        double normSquaredReal = 0.0;
        double normSquaredImag = 0.0;
        int i = this._dimension;
        while (--i >= 0) {
            double real = this._reals[i];
            double imag = this._imags[i];
            normSquaredReal += real * real - imag * imag;
            normSquaredImag += real * imag * 2.0;
        }
        return Complex.valueOf(normSquaredReal, normSquaredImag).sqrt();
    }

    @Override
    public int getDimension() {
        return this._dimension;
    }

    @Override
    public Complex get(int i) {
        if (i >= this._dimension) {
            throw new IndexOutOfBoundsException();
        }
        return Complex.valueOf(this._reals[i], this._imags[i]);
    }

    @Override
    public ComplexVector opposite() {
        ComplexVector V = (ComplexVector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._reals[i] = -this._reals[i];
            V._imags[i] = -this._imags[i];
            ++i;
        }
        return V;
    }

    @Override
    public ComplexVector plus(Vector<Complex> that) {
        ComplexVector T = ComplexVector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        ComplexVector V = (ComplexVector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._reals[i] = this._reals[i] + T._reals[i];
            V._imags[i] = this._imags[i] + T._imags[i];
            ++i;
        }
        return V;
    }

    public ComplexVector minus(Vector<Complex> that) {
        ComplexVector T = ComplexVector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        ComplexVector V = (ComplexVector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._reals[i] = this._reals[i] - T._reals[i];
            V._imags[i] = this._imags[i] - T._imags[i];
            ++i;
        }
        return V;
    }

    @Override
    public ComplexVector times(Complex k) {
        ComplexVector V = (ComplexVector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            double real = this._reals[i];
            double imag = this._imags[i];
            V._reals[i] = real * k.getReal() - imag * k.getImaginary();
            V._imags[i] = real * k.getImaginary() + imag * k.getReal();
            ++i;
        }
        return V;
    }

    @Override
    public Complex times(Vector<Complex> that) {
        ComplexVector T = ComplexVector.valueOf(that);
        if (T._dimension != this._dimension) {
            throw new DimensionException();
        }
        double sumReal = this._reals[0] * T._reals[0] - this._imags[0] * T._imags[0];
        double sumImag = this._reals[0] * T._imags[0] + this._imags[0] * T._reals[0];
        int i = 1;
        while (i < this._dimension) {
            sumReal += this._reals[i] * T._reals[i] - this._imags[i] * T._imags[i];
            sumImag += this._reals[i] * T._imags[i] + this._imags[i] * T._reals[i];
            ++i;
        }
        return Complex.valueOf(sumReal, sumImag);
    }

    @Override
    public ComplexVector copy() {
        ComplexVector V = (ComplexVector)FACTORY.array(this._dimension);
        V._dimension = this._dimension;
        int i = 0;
        while (i < this._dimension) {
            V._reals[i] = this._reals[i];
            V._imags[i] = this._imags[i];
            ++i;
        }
        return V;
    }

    void set(int i, Complex c) {
        this._reals[i] = c.getReal();
        this._imags[i] = c.getImaginary();
    }

    static ComplexVector newInstance(int n) {
        ComplexVector V = (ComplexVector)FACTORY.array(n);
        V._dimension = n;
        return V;
    }

    /* synthetic */ ComplexVector(int n, ComplexVector complexVector) {
        this(n);
    }
}

