/**
 * Opt4J is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 * 
 * Opt4J is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Opt4J. If not, see http://www.gnu.org/licenses/. 
 */

package org.opt4j.operator.crossover;

import org.opt4j.common.random.Rand;
import org.opt4j.operator.normalize.NormalizeDouble;

import com.google.inject.Inject;

/**
 * The {@link CrossoverDoubleDefault} is a {@link CrossoverDoubleSBX} with
 * {@code nu=15}.
 * 
 * @author lukasiewycz
 * 
 */
public class CrossoverDoubleDefault extends CrossoverDoubleSBX {

	/**
	 * Constructs a new {@link CrossoverDoubleSBX} with {@code nu=15}.
	 * 
	 * @param normalize
	 *            the normalize operator
	 * @param random
	 *            the random number generator
	 */
	@Inject
	public CrossoverDoubleDefault(NormalizeDouble normalize, Rand random) {
		super(15, normalize, random);
	}

}
