/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.accuracy.transformation;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.accuracy.transformation.AbstractAccuracyInfluenceSEFFTransformationStrategy;
import org.palladiosimulator.analyzer.accuracy.transformation.PCMRandomVariableSpecificationAccuracyMaximumTrafo;
import org.palladiosimulator.analyzer.accuracy.transformation.ValidationPrecisionToMaximumLongValue;
import org.palladiosimulator.analyzer.quality.qualityannotation.NoPrecision;
import org.palladiosimulator.analyzer.quality.qualityannotation.REPrecision;
import org.palladiosimulator.analyzer.quality.util.EcoreCopierCreatingNewIds;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.CallAction;
import org.palladiosimulator.pcm.seff.CallReturnAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalCallAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.seff_performance.InfrastructureCall;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.ResourceCall;
import org.palladiosimulator.pcm.seff.seff_reliability.FailureHandlingEntity;

public class AccuracyInfluenceSEFFTransformationStrategyMaximum
extends AbstractAccuracyInfluenceSEFFTransformationStrategy {
    private static final Logger LOGGER = Logger.getLogger(AccuracyInfluenceSEFFTransformationStrategyMaximum.class);
    private EcoreCopierCreatingNewIds copier = new EcoreCopierCreatingNewIds();
    private final PCMRandomVariableSpecificationAccuracyMaximumTrafo randomVariableMaximumTrafo = new PCMRandomVariableSpecificationAccuracyMaximumTrafo();
    private final ValidationPrecisionToMaximumLongValue precisionMaximalValue = new ValidationPrecisionToMaximumLongValue();

    public AccuracyInfluenceSEFFTransformationStrategyMaximum(PCMResourceSetPartition pcmPartition) {
        super(pcmPartition);
    }

    @Override
    protected void modifyComponentExternalCall(ExternalCallAction call, REPrecision precision) {
        this.handleInputParametersOfCallAction((CallAction)call, precision);
        this.precisionMaximalValue.setAbsoluteValue(1L);
        long max = (Long)this.precisionMaximalValue.doSwitch((EObject)precision.getDefaultPrecisionNumberOfCalls());
        if (max > 1L) {
            ExternalCallAction eca = null;
            ExternalCallAction predecessor = call;
            AbstractAction finalSuccessor = call.getSuccessor_AbstractAction();
            int i = 1;
            while ((long)i < max) {
                eca = SeffFactory.eINSTANCE.createExternalCallAction();
                if (i == 1) {
                    call.setSuccessor_AbstractAction((AbstractAction)eca);
                }
                eca.setCalledService_ExternalService(call.getCalledService_ExternalService());
                eca.setEntityName(String.valueOf(call.getEntityName()) + " Accuracy Influence Replica " + i);
                eca.setRetryCount(eca.getRetryCount());
                this.copyInputVariableUsages((CallAction)eca, (CallAction)call);
                this.copyReturnVariableUsage((CallReturnAction)eca, (CallReturnAction)call);
                this.copyFailureTypes((FailureHandlingEntity)eca, (FailureHandlingEntity)call);
                eca.setRole_ExternalService(call.getRole_ExternalService());
                eca.setPredecessor_AbstractAction((AbstractAction)predecessor);
                predecessor = eca;
                ++i;
            }
            if (eca != null) {
                eca.setSuccessor_AbstractAction(finalSuccessor);
            } else {
                String msg = "Impossible control flow in implemenation. Correct implemenatation.";
                LOGGER.fatal((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    protected void modifyComponentInternalCall(InternalCallAction call, REPrecision precision) {
        this.handleInputParametersOfCallAction((CallAction)call, precision);
        this.precisionMaximalValue.setAbsoluteValue(1L);
        long max = (Long)this.precisionMaximalValue.doSwitch((EObject)precision.getDefaultPrecisionNumberOfCalls());
        if (max > 1L) {
            InternalCallAction ica = null;
            InternalCallAction predecessor = call;
            AbstractAction finalSuccessor = call.getSuccessor_AbstractAction();
            int i = 1;
            while ((long)i < max) {
                ica = SeffFactory.eINSTANCE.createInternalCallAction();
                if (i == 1) {
                    call.setSuccessor_AbstractAction((AbstractAction)ica);
                }
                ica.setCalledResourceDemandingInternalBehaviour(call.getCalledResourceDemandingInternalBehaviour());
                ica.setEntityName(String.valueOf(call.getEntityName()) + " Accuracy Influence Replica " + i);
                this.copyInputVariableUsages((CallAction)ica, (CallAction)call);
                ica.setPredecessor_AbstractAction((AbstractAction)predecessor);
                predecessor = ica;
                ++i;
            }
            if (ica != null) {
                ica.setSuccessor_AbstractAction(finalSuccessor);
            } else {
                String msg = "Impossible control flow in implemenation. Correct implemenatation.";
                LOGGER.fatal((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    @Override
    protected void modifyInfrastructureCall(InfrastructureCall call, REPrecision precision) {
        this.randomVariableMaximumTrafo.setModifiedVariable(call.getNumberOfCalls__InfrastructureCall());
        this.randomVariableMaximumTrafo.doSwitch((EObject)precision.getDefaultPrecisionNumberOfCalls());
        this.handleInputParametersOfCallAction((CallAction)call, precision);
    }

    @Override
    protected void modifyResourceCall(ResourceCall call, REPrecision precision) {
        this.randomVariableMaximumTrafo.setModifiedVariable(call.getNumberOfCalls__ResourceCall());
        this.randomVariableMaximumTrafo.doSwitch((EObject)precision.getDefaultPrecisionNumberOfCalls());
        for (VariableUsage variableUsage : call.getInputVariableUsages__CallAction()) {
            for (VariableCharacterisation varChar : variableUsage.getVariableCharacterisation_VariableUsage()) {
                this.randomVariableMaximumTrafo.setModifiedVariable(varChar.getSpecification_VariableCharacterisation());
                this.randomVariableMaximumTrafo.doSwitch((EObject)precision.getDefaultPrecisionCallParameter());
            }
        }
    }

    @Override
    protected void modifyResourceDemand(ParametricResourceDemand demand, REPrecision precision) {
        this.randomVariableMaximumTrafo.setModifiedVariable(demand.getSpecification_ParametericResourceDemand());
        this.randomVariableMaximumTrafo.doSwitch((EObject)precision.getDefaultPrecisionNumberOfCalls());
        if (!(precision.getDefaultPrecisionCallParameter() instanceof NoPrecision)) {
            String msg = "A ResourceDemand has no parameters. The default precision for call parameters must be set to NoPrecision.";
            LOGGER.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private void handleInputParametersOfCallAction(CallAction call, REPrecision precision) {
        for (VariableUsage variableUsage : call.getInputVariableUsages__CallAction()) {
            for (VariableCharacterisation varChar : variableUsage.getVariableCharacterisation_VariableUsage()) {
                this.randomVariableMaximumTrafo.setModifiedVariable(varChar.getSpecification_VariableCharacterisation());
                this.randomVariableMaximumTrafo.doSwitch((EObject)precision.getDefaultPrecisionCallParameter());
            }
        }
    }

    private void copyInputVariableUsages(CallAction target, CallAction source) {
        for (VariableUsage variableUsage : source.getInputVariableUsages__CallAction()) {
            VariableUsage newVU = ParameterFactory.eINSTANCE.createVariableUsage();
            newVU.setNamedReference__VariableUsage((AbstractNamedReference)this.copier.copy((EObject)variableUsage.getNamedReference__VariableUsage()));
            for (VariableCharacterisation varChar : variableUsage.getVariableCharacterisation_VariableUsage()) {
                VariableCharacterisation newVC = ParameterFactory.eINSTANCE.createVariableCharacterisation();
                newVC.setSpecification_VariableCharacterisation(varChar.getSpecification_VariableCharacterisation());
                newVU.getVariableCharacterisation_VariableUsage().add((Object)newVC);
            }
            target.getInputVariableUsages__CallAction().add((Object)newVU);
        }
    }

    private void copyReturnVariableUsage(CallReturnAction target, CallReturnAction source) {
        for (VariableUsage variableUsage : source.getReturnVariableUsage__CallReturnAction()) {
            VariableUsage newVU = ParameterFactory.eINSTANCE.createVariableUsage();
            newVU.setNamedReference__VariableUsage((AbstractNamedReference)this.copier.copy((EObject)variableUsage.getNamedReference__VariableUsage()));
            for (VariableCharacterisation varChar : variableUsage.getVariableCharacterisation_VariableUsage()) {
                VariableCharacterisation newVC = ParameterFactory.eINSTANCE.createVariableCharacterisation();
                newVC.setSpecification_VariableCharacterisation(varChar.getSpecification_VariableCharacterisation());
                newVU.getVariableCharacterisation_VariableUsage().add((Object)newVC);
            }
            target.getReturnVariableUsage__CallReturnAction().add((Object)newVU);
        }
    }

    private void copyFailureTypes(FailureHandlingEntity target, FailureHandlingEntity source) {
        for (FailureType failureType : source.getFailureTypes_FailureHandlingEntity()) {
            target.getFailureTypes_FailureHandlingEntity().add((Object)failureType);
        }
    }
}

