/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.configurations;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.runconfig.SensitivityAnalysisConfiguration;

public abstract class AbstractCodeGenerationWorkflowRunConfiguration
extends AbstractPCMWorkflowRunConfiguration
implements Cloneable {
    private List<String> codeGenerationAdvices = null;
    private List<String> codeGenerationRequiredBundles = null;
    protected boolean overwriteWithoutAsking = false;
    protected boolean loadMiddlewareAndCompletionFiles = false;
    protected CodeGenerationAdvice codeGenerationAdvice = CodeGenerationAdvice.SIMULATION;
    protected List<SensitivityAnalysisConfiguration> sensitivityAnalysisConfigurationList = new ArrayList<SensitivityAnalysisConfiguration>();
    protected boolean sensitivityAnalysisEnabled;

    public AbstractCodeGenerationWorkflowRunConfiguration() {
        this.codeGenerationAdvices = new ArrayList<String>();
        this.codeGenerationRequiredBundles = new ArrayList<String>();
    }

    private String getSensitivityAnalysisIdentifier() {
        String result = "";
        for (SensitivityAnalysisConfiguration sac : this.sensitivityAnalysisConfigurationList) {
            result = String.valueOf(result) + "." + sac.getRunNo();
        }
        return result;
    }

    @Override
    public String getStoragePluginID() {
        return this.sensitivityAnalysisEnabled ? String.valueOf(super.getStoragePluginID()) + this.getSensitivityAnalysisIdentifier() : super.getStoragePluginID();
    }

    @Override
    public void setOverwriteWithoutAsking(boolean overwriteWithoutAsking) {
        this.overwriteWithoutAsking = overwriteWithoutAsking;
    }

    @Override
    public boolean isOverwriteWithoutAsking() {
        return this.overwriteWithoutAsking;
    }

    public void setLoadMiddlewareAndCompletionFiles(boolean loadMiddlewareAndCompletionFiles) {
        this.loadMiddlewareAndCompletionFiles = loadMiddlewareAndCompletionFiles;
    }

    public boolean isLoadMiddlewareAndCompletionFiles() {
        return this.loadMiddlewareAndCompletionFiles;
    }

    public boolean isSensitivityAnalysisEnabled() {
        return this.sensitivityAnalysisEnabled;
    }

    public List<SensitivityAnalysisConfiguration> getSensitivityAnalysisConfigurations() {
        if (!this.isSensitivityAnalysisEnabled()) {
            throw new UnsupportedOperationException("GetSensitivityAnalysisConfiguration is only supported if isSensitivityAnaysisEnabled is true!");
        }
        return this.sensitivityAnalysisConfigurationList;
    }

    public void setSensitivityAnalysisEnabled(boolean sensitivityAnalysisEnabled) {
        this.checkFixed();
        this.sensitivityAnalysisEnabled = sensitivityAnalysisEnabled;
    }

    public void setSensitivityAnalysisConfiguration(SensitivityAnalysisConfiguration sensitivityConfig) {
        this.checkFixed();
        this.sensitivityAnalysisConfigurationList = new ArrayList<SensitivityAnalysisConfiguration>();
        this.sensitivityAnalysisConfigurationList.add(sensitivityConfig);
    }

    public void setSensitivityAnalysisConfigurationList(List<SensitivityAnalysisConfiguration> sensitivityConfigList) {
        this.checkFixed();
        this.sensitivityAnalysisConfigurationList = sensitivityConfigList;
    }

    public CodeGenerationAdvice getCodeGenerationAdvice() {
        return this.codeGenerationAdvice;
    }

    public String getCodeGenerationAdvicesFile() {
        return this.codeGenerationAdvice.getTemplateFile();
    }

    public void setCodeGenerationAdvicesFile(CodeGenerationAdvice advice) {
        this.codeGenerationAdvice = advice;
    }

    public void addCodeGenerationAdvice(String advice) {
        this.codeGenerationAdvices.add(advice);
    }

    public void addRequiredBundle(String bundleid) {
        if (!this.codeGenerationRequiredBundles.contains(bundleid)) {
            this.codeGenerationRequiredBundles.add(bundleid);
        }
    }

    public List<String> getCodeGenerationAdvices() {
        return this.codeGenerationAdvices;
    }

    public List<String> getCodeGenerationRequiredBundles() {
        return this.codeGenerationRequiredBundles;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        AbstractCodeGenerationWorkflowRunConfiguration config = (AbstractCodeGenerationWorkflowRunConfiguration)super.clone();
        config.codeGenerationAdvice = this.codeGenerationAdvice;
        config.loadMiddlewareAndCompletionFiles = this.loadMiddlewareAndCompletionFiles;
        config.overwriteWithoutAsking = this.overwriteWithoutAsking;
        ArrayList<SensitivityAnalysisConfiguration> newSensitivityAnalysisConfigurationList = new ArrayList<SensitivityAnalysisConfiguration>(this.sensitivityAnalysisConfigurationList.size());
        for (SensitivityAnalysisConfiguration saconfig : this.sensitivityAnalysisConfigurationList) {
            newSensitivityAnalysisConfigurationList.add(saconfig.getClone());
        }
        config.sensitivityAnalysisConfigurationList = newSensitivityAnalysisConfigurationList;
        config.sensitivityAnalysisEnabled = this.sensitivityAnalysisEnabled;
        return config;
    }

    public static enum CodeGenerationAdvice {
        SIMULATION("simulation_template_methods"),
        POJO("pojo_template_methods"),
        EJB3("ejb3_template_methods"),
        SERVLET("servlet_template_methods"),
        PROTO("prototype_template_methods");

        private String templateFile;

        private CodeGenerationAdvice(String templateFile) {
            this.templateFile = templateFile;
        }

        public String getTemplateFile() {
            return this.templateFile;
        }
    }
}

