/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;

public class EventsTransformationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(EventsTransformationJob.class);
    protected static final String TRANSFORMATION_SCRIPT = "platform:/plugin/org.palladiosimulator.pcm.resources/transformations/events/transformation-psm.qvto";
    private static final String TRACESFOLDER = "traces";
    private MDSDBlackboard blackboard;
    private final AbstractPCMWorkflowRunConfiguration configuration;

    public EventsTransformationJob(AbstractPCMWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        block4: {
            ModelLocation[] modelLocations = this.getRequiredModels(this.blackboard);
            if (this.checkEventGroups(modelLocations)) {
                LOGGER.info((Object)"Skipping Event Transformation: No EventGroup was found");
                return;
            }
            this.configuration.getEventMiddlewareFile();
            URI traceFileURI = URI.createURI((String)EventsTransformationJob.getProject(this.configuration.getStoragePluginID()).getFolder(TRACESFOLDER).getFullPath().toOSString());
            URI scriptFileURI = URI.createURI((String)TRANSFORMATION_SCRIPT);
            QVTOTransformationJobConfiguration qvtoConfig = new QVTOTransformationJobConfiguration();
            qvtoConfig.setInoutModels(modelLocations);
            qvtoConfig.setTraceFileURI(traceFileURI);
            qvtoConfig.setScriptFileURI(scriptFileURI);
            qvtoConfig.setOptions(new HashMap());
            QVTOTransformationJob job = new QVTOTransformationJob(qvtoConfig);
            job.setBlackboard(this.blackboard);
            try {
                job.execute(monitor);
            }
            catch (JobFailedException e) {
                if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                    LOGGER.error((Object)("Failed to perform Event Transformation: " + e.getMessage()));
                }
                if (!LOGGER.isEnabledFor((Priority)Level.INFO)) break block4;
                LOGGER.info((Object)"Trying to continue processing");
            }
        }
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        partition.loadModel(this.configuration.getEventMiddlewareFile());
        SavePartitionToDiskJob savePartitionJob = new SavePartitionToDiskJob("org.palladiosimulator.pcmmodels.partition");
        savePartitionJob.setBlackboard(this.blackboard);
        savePartitionJob.execute(monitor);
    }

    private boolean checkEventGroups(ModelLocation[] modelLocations) {
        boolean skipQVTO = true;
        ModelLocation[] modelLocationArray = modelLocations;
        int n = modelLocations.length;
        int n2 = 0;
        while (n2 < n) {
            Object eventgroup;
            ResourceSetPartition partition;
            List contents;
            Repository repo;
            ModelLocation loc = modelLocationArray[n2];
            URI modelId = loc.getModelID();
            String fileExtension = modelId.fileExtension();
            if (fileExtension != null && fileExtension.equals("repository") && (repo = (Repository)EcoreUtil.getObjectByType((Collection)(contents = (partition = (ResourceSetPartition)this.blackboard.getPartition(loc.getPartitionID())).getContents(modelId)), (EClassifier)RepositoryPackage.eINSTANCE.getRepository())) != null && (eventgroup = EcoreUtil.getObjectByType((Collection)repo.getInterfaces__Repository(), (EClassifier)RepositoryPackage.eINSTANCE.getEventGroup())) != null) {
                skipQVTO = false;
            }
            ++n2;
        }
        return skipQVTO;
    }

    private ModelLocation[] getRequiredModels(MDSDBlackboard blackboard) {
        ModelLocation allocationModelLocation = null;
        ModelLocation systemModelLocation = null;
        ModelLocation repositoryModelLocation = null;
        String pcmModelPartitionId = "org.palladiosimulator.pcmmodels.partition";
        ResourceSetPartition partition = (ResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        partition.resolveAllProxies();
        for (Resource r : partition.getResourceSet().getResources()) {
            URI modelURI = r.getURI();
            String fileExtension = modelURI.fileExtension();
            if (fileExtension.equals("allocation")) {
                allocationModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (fileExtension.equals("system")) {
                systemModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
            }
            if (!fileExtension.equals("repository") || repositoryModelLocation != null || modelURI.toString().startsWith("pathmap://") || modelURI.toString().contains("PrimitiveTypes.repository")) continue;
            repositoryModelLocation = new ModelLocation("org.palladiosimulator.pcmmodels.partition", modelURI);
        }
        ArrayList<ModelLocation> modelLocations = new ArrayList<ModelLocation>();
        modelLocations.add(allocationModelLocation);
        modelLocations.add(systemModelLocation);
        modelLocations.add(repositoryModelLocation);
        modelLocations.add(this.getEventMiddlewareModel(blackboard));
        return modelLocations.toArray(new ModelLocation[0]);
    }

    private ModelLocation getEventMiddlewareModel(MDSDBlackboard blackboard) {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        pcmPartition.resolveAllProxies();
        if (pcmPartition.getResourceSet().getResources().size() > 0) {
            Resource r = (Resource)pcmPartition.getResourceSet().getResources().get(0);
            return new ModelLocation("org.palladiosimulator.pcmmodels.partition", r.getURI());
        }
        return new ModelLocation("org.palladiosimulator.pcmmodels.partition", URI.createURI((String)""));
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Add event transformation job";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public static IProject getProject(String projectId) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }
}

