/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;

public class LoadPCMModelsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(LoadPCMModelsJob.class);
    private MDSDBlackboard blackboard;
    private AbstractPCMWorkflowRunConfiguration configuration = null;

    public LoadPCMModelsJob(AbstractPCMWorkflowRunConfiguration configuration) {
        super(false);
        this.configuration = configuration;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Loading PCM models");
        }
        for (String modelFile : this.configuration.getPCMModelFiles()) {
            pcmPartition.loadModel(modelFile);
        }
        pcmPartition.loadModel(this.configuration.getRMIMiddlewareFile());
        pcmPartition.loadModel(this.configuration.getEventMiddlewareFile());
        pcmPartition.resolveAllProxies();
    }

    public String getName() {
        return "Perform PCM Model Load";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

