/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;

public class PreparePCMBlackboardPartitionJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(PreparePCMBlackboardPartitionJob.class);
    private MDSDBlackboard blackboard;
    public static final URI PCM_PALLADIO_RESOURCE_TYPE_URI = URI.createURI((String)"pathmap://PCM_MODELS/Palladio.resourcetype");
    public static final URI PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI = URI.createURI((String)"pathmap://PCM_MODELS/PrimitiveTypes.repository");

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Creating PCM Model Partition");
        }
        PCMResourceSetPartition pcmPartition = new PCMResourceSetPartition();
        this.blackboard.addPartition("org.palladiosimulator.pcmmodels.partition", (Object)pcmPartition);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing PCM EPackages");
        }
        pcmPartition.initialiseResourceSetEPackages(AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES);
        pcmPartition.loadModel(PCM_PALLADIO_PRIMITIVE_TYPE_REPOSITORY_URI);
        pcmPartition.loadModel(PCM_PALLADIO_RESOURCE_TYPE_URI);
    }

    public String getName() {
        return "Prepare PCM Blackboard Partions";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
        this.blackboard.removePartition("org.palladiosimulator.pcmmodels.partition");
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

