/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.workflow.runconfig;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.ConstantsContainer;
import org.palladiosimulator.analyzer.workflow.runconfig.AbstractConfigurationTab;

public class ConfigurationTab
extends AbstractConfigurationTab {
    private static final String GROUP_ACCURACY_LABEL = "Accuracy influence analysis";
    private static final String BUTTON_SIMULATE_ACCURACY_LABEL = "Analyse accuracy influence";
    private static final String DEFAULT_ACCURACY_QUALITY_ANNOTATION_FILE_LABEL = "Quality Annotation File";
    protected Button clearButton;
    private Button simulateAccuracyButton;
    private Text textAccuracyQualityAnnotationFile;

    @Override
    protected void createAccuracySection(Composite container) {
        Group accuracyGroup = new Group(container, 0);
        accuracyGroup.setText(GROUP_ACCURACY_LABEL);
        GridData gd_accuracyGroup = new GridData(4, 0x1000000, true, false);
        accuracyGroup.setLayoutData((Object)gd_accuracyGroup);
        accuracyGroup.setLayout((Layout)new GridLayout());
        this.simulateAccuracyButton = new Button((Composite)accuracyGroup, 32);
        this.simulateAccuracyButton.setLayoutData((Object)gd_accuracyGroup);
        this.simulateAccuracyButton.setText(BUTTON_SIMULATE_ACCURACY_LABEL);
        this.simulateAccuracyButton.setSelection(false);
        this.simulateAccuracyButton.addSelectionListener(this.selectionListener);
        this.textAccuracyQualityAnnotationFile = new Text((Composite)accuracyGroup, 2052);
        this.textAccuracyQualityAnnotationFile.setLayoutData((Object)gd_accuracyGroup);
        this.textAccuracyQualityAnnotationFile.addModifyListener(this.modifyListener);
        TabHelper.createFileInputSection((Composite)accuracyGroup, (ModifyListener)this.modifyListener, (String)DEFAULT_ACCURACY_QUALITY_ANNOTATION_FILE_LABEL, (String[])ConstantsContainer.ACCURACY_QUALITY_ANNOTATION_EXTENSION, (Text)this.textAccuracyQualityAnnotationFile, (Shell)this.getShell(), (String)"");
    }

    @Override
    protected void createDeleteTemporaryDataAfterAnalysisSection(Composite container) {
        Group clearGroup = new Group(container, 0);
        clearGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        clearGroup.setText("Temporary Data");
        clearGroup.setLayout((Layout)new GridLayout());
        this.clearButton = new Button((Composite)clearGroup, 32);
        this.clearButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.clearButton.setText("Delete temporary data after analysis");
        this.clearButton.addSelectionListener(this.selectionListener);
    }

    @Override
    protected void createFurtherSections(Composite container) {
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.clearButton.setSelection(configuration.getAttribute("clear", ConstantsContainer.DEFAULT_DELETE_TEMPORARY_DATA_AFTER_ANALYSIS.booleanValue()));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"Delete temporaray data after analysis.", (String)e.getMessage());
        }
        try {
            this.simulateAccuracyButton.setSelection(configuration.getAttribute("simulateAccuracy", ConstantsContainer.DEFAULT_ANALYSE_ACCURACY.booleanValue()));
            this.textAccuracyQualityAnnotationFile.setText(configuration.getAttribute("accuracyQualityAnnotationFile", ""));
        }
        catch (CoreException e) {
            this.simulateAccuracyButton.setSelection(ConstantsContainer.DEFAULT_ANALYSE_ACCURACY.booleanValue());
            this.textAccuracyQualityAnnotationFile.setText("");
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("clear", this.clearButton.getSelection());
        configuration.setAttribute("simulateAccuracy", this.simulateAccuracyButton.getSelection());
        configuration.setAttribute("accuracyQualityAnnotationFile", this.textAccuracyQualityAnnotationFile.getText());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("clear", ConstantsContainer.DEFAULT_DELETE_TEMPORARY_DATA_AFTER_ANALYSIS.booleanValue());
        configuration.setAttribute("simulateAccuracy", ConstantsContainer.DEFAULT_ANALYSE_ACCURACY.booleanValue());
        configuration.setAttribute("accuracyQualityAnnotationFile", "");
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean tmp = super.isValid(launchConfig);
        if (this.simulateAccuracyButton.getSelection() && !TabHelper.validateFilenameExtension((String)this.textAccuracyQualityAnnotationFile.getText(), (String[])ConstantsContainer.ACCURACY_QUALITY_ANNOTATION_EXTENSION)) {
            this.setErrorMessage("Quality Annotation File must be present for accuracy influence analysis.");
            return false;
        }
        return tmp;
    }
}

