/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.designpatterns;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.palladiosimulator.commons.designpatterns.IAbstractObservable;

public abstract class AbstractObservable<ObserverInterfaceType>
implements IAbstractObservable<ObserverInterfaceType> {
    private ObserverInterfaceType m_eventDispatcher = null;
    private final ObserverPool<ObserverInterfaceType> m_observers = new ObserverPool();

    public ObserverInterfaceType getEventDispatcher() {
        if (this.m_eventDispatcher == null) {
            Class<?> superClass = this.getClass();
            while (superClass.getSuperclass() != AbstractObservable.class) {
                superClass = superClass.getSuperclass();
            }
            Type genericClass = superClass.getGenericSuperclass();
            if (genericClass instanceof Class) {
                new RuntimeException("Observable requires a parameter type!");
            } else {
                ParameterizedType genericType = (ParameterizedType)genericClass;
                Type[] typeArguments = genericType.getActualTypeArguments();
                this.m_eventDispatcher = this.m_observers.createEventDispatcher((Class)typeArguments[0]);
            }
        }
        return this.m_eventDispatcher;
    }

    @Override
    public void addObserver(ObserverInterfaceType observer) {
        if (observer == null || this.m_observers.getObservers().contains(observer)) {
            throw new IllegalArgumentException("Invalid observer added");
        }
        this.m_observers.addObserver(observer);
    }

    @Override
    public void removeObserver(ObserverInterfaceType observer) {
        if (observer == null || !this.m_observers.getObservers().contains(observer)) {
            throw new IllegalArgumentException("Invalid observer removed");
        }
        this.m_observers.removeObserver(observer);
    }

    public List<ObserverInterfaceType> getObservers() {
        return this.m_observers.getObservers();
    }

    public void removeAllObserver() {
        this.m_observers.removeAllObserver();
    }

    private class ObserverPool<T>
    implements InvocationHandler {
        private final List<T> m_pool = new CopyOnWriteArrayList<T>();

        private ObserverPool() {
        }

        List<T> getObservers() {
            return Collections.unmodifiableList(this.m_pool);
        }

        void addObserver(T observer) {
            this.m_pool.add(observer);
        }

        boolean removeObserver(T observer) {
            return this.m_pool.remove(observer);
        }

        void removeAllObserver() {
            this.m_pool.clear();
        }

        T createEventDispatcher(Class<?> observerClass) {
            Object dispatcher = Proxy.newProxyInstance(observerClass.getClassLoader(), new Class[]{observerClass}, (InvocationHandler)this);
            return (T)dispatcher;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            for (T observer : this.m_pool) {
                method.invoke(observer, args);
            }
            return null;
        }
    }
}

