/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.dialogs.datatype;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;

public class DataTypeCommand {
    private TransactionalEditingDomain editingDomain;

    public DataTypeCommand(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void createCollectionDataType(final Repository repository, final DataType dataType, final DataType innerDataType, final String entityName) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                if (dataType != null) {
                    CollectionDataType collectionDataType = (CollectionDataType)dataType;
                    String typeName = collectionDataType.getEntityName();
                    DataType innerType = collectionDataType.getInnerType_CollectionDataType();
                    if (entityName != null && !typeName.equals(entityName)) {
                        collectionDataType.setEntityName(entityName);
                    }
                    if (innerDataType != null && !innerType.equals(innerDataType)) {
                        collectionDataType.setInnerType_CollectionDataType(innerDataType);
                    }
                } else {
                    CollectionDataType collectionDataType = RepositoryFactory.eINSTANCE.createCollectionDataType();
                    collectionDataType.setRepository__DataType(repository);
                    Assert.isNotNull((Object)collectionDataType);
                    Assert.isNotNull((Object)innerDataType);
                    Assert.isNotNull((Object)entityName);
                    collectionDataType.setEntityName(entityName);
                    collectionDataType.setInnerType_CollectionDataType(innerDataType);
                }
            }
        };
        recCommand.setDescription("Add new/Edite CollectionDataType");
        this.editingDomain.getCommandStack().execute((Command)recCommand);
    }

    public void createCompositeDataType(final Repository repository, final CompositeDataType compositeDataType, final String entityName) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                Assert.isNotNull((Object)compositeDataType);
                if (entityName != null && !compositeDataType.getEntityName().equals(entityName)) {
                    compositeDataType.setEntityName(entityName);
                }
                if (repository != null) {
                    compositeDataType.setRepository__DataType(repository);
                }
            }
        };
        recCommand.setDescription("Add new CompositeDataType");
        this.editingDomain.getCommandStack().execute((Command)recCommand);
    }
}

