/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.dialogs.exception;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;
import org.palladiosimulator.editors.dialogs.exception.ExceptionsDialog;
import org.palladiosimulator.editors.dialogs.exception.ExceptionsItemProvider;
import org.palladiosimulator.pcm.repository.ExceptionType;

public class ExceptionsCellModifier
implements ICellModifier {
    private List<String> columnNames = Arrays.asList(ExceptionsDialog.getColumnNames());
    private ExceptionType exceptionType;
    private TableViewer viewer;
    protected TransactionalEditingDomain editingDomain = null;

    public ExceptionsCellModifier(TableViewer viewer, TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return new ExceptionsItemProvider(null).getColumnText(element, this.columnNames.indexOf(property));
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnNames.indexOf(property);
        Assert.isNotNull((Object)element);
        TableItem item = (TableItem)element;
        this.exceptionType = (ExceptionType)item.getData();
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                String valueString = ((String)value).trim();
                this.setExceptionName(valueString);
            }
        }
    }

    private void setExceptionName(final String value) {
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ExceptionsCellModifier.this.exceptionType.setExceptionName(value);
            }
        };
        if (!value.equals(this.exceptionType.getExceptionName())) {
            recCommand.setLabel("Set ParameterName");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
            this.viewer.refresh();
        }
    }
}

